<?php

namespace Drop\GELProximity\Model;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Magento\Framework\Model\AbstractModel;

/**
 * Class GelShipment
 * @package Drop\GELProximity\Model
 */
class GelShipment extends AbstractModel implements GelShipmentInterface
{
    /**
     * @const
     */
    public const CACHE_TAG = 'gel_shipment';

    /**
     * @var string
     */
    protected $_cacheTag = 'gel_shipment';

    /**
     * @var string
     */
    protected $_eventPrefix = 'gel_shipment_model';

    /**
     * Init resource model
     */
    protected function _construct(): void
    {
        $this->_init(ResourceModel\GelShipment::class);
    }

    /**
     * {@inheritDoc}
     */
    public function getId()
    {
        return $this->_getData(self::ENTITY_ID);
    }

    /**
     * {@inheritDoc}
     */
    public function getPickupPointId()
    {
        return $this->_getData(self::PICKUP_POINT_ID);
    }

    /**
     * {@inheritDoc}
     */
    public function setPickupPointId(int $pickupPointId): GelShipmentInterface
    {
        $this->setData(self::PICKUP_POINT_ID, $pickupPointId);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getCost()
    {
        return $this->_getData(self::COST);
    }

    /**
     * {@inheritDoc}
     */
    public function setCost(?float $cost): GelShipmentInterface
    {
        $this->setData(self::COST, $cost);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getCurrency()
    {
        return $this->_getData(self::CURRENCY);
    }

    /**
     * {@inheritDoc}
     */
    public function setCurrency(?string $currency): GelShipmentInterface
    {
        $this->setData(self::CURRENCY, $currency);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getIsReturn()
    {
        return $this->_getData(self::IS_RETURN);
    }

    /**
     * {@inheritDoc}
     */
    public function setIsReturn(bool $isReturn): GelShipmentInterface
    {
        $this->setData(self::IS_RETURN, $isReturn);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getAdditionalPickupPointData()
    {
        return $this->_getData(self::ADDITIONAL_PICKUP_POINT_DATA);
    }

    /**
     * {@inheritDoc}
     */
    public function setAdditionalPickupPointData(string $additionalPickupPointData): GelShipmentInterface
    {
        $this->setData(self::ADDITIONAL_PICKUP_POINT_DATA, $additionalPickupPointData);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getQuoteReference()
    {
        return $this->_getData(self::QUOTE_REFERENCE);
    }

    /**
     * {@inheritDoc}
     */
    public function setQuoteReference(string $quoteReference): GelShipmentInterface
    {
        $this->setData(self::QUOTE_REFERENCE, $quoteReference);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getQuoteId()
    {
        return $this->_getData(self::QUOTE_ID);
    }

    /**
     * {@inheritDoc}
     */
    public function setQuoteId(int $quoteId): GelShipmentInterface
    {
        $this->setData(self::QUOTE_ID, $quoteId);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getOrderId()
    {
        return $this->_getData(self::ORDER_ID);
    }

    /**
     * {@inheritDoc}
     */
    public function setOrderId(int $orderId): GelShipmentInterface
    {
        $this->setData(self::ORDER_ID, $orderId);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getExternalOrderId()
    {
        return $this->_getData(self::EXTERNAL_ORDER_ID);
    }

    /**
     * {@inheritDoc}
     */
    public function setExternalOrderId(int $externalOrderId): GelShipmentInterface
    {
        $this->setData(self::EXTERNAL_ORDER_ID, $externalOrderId);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getCreatedAt()
    {
        return $this->_getData(self::CREATED_AT);
    }

    /**
     * {@inheritDoc}
     */
    public function setCreatedAt(string $createdAt): GelShipmentInterface
    {
        $this->setData(self::CREATED_AT, $createdAt);
        return $this;
    }

    /**
     * {@inheritDoc}
     */
    public function getUpdatedAt()
    {
        return $this->_getData(self::UPDATED_AT);
    }

    /**
     * {@inheritDoc}
     */
    public function setUpdatedAt(string $updatedAt): GelShipmentInterface
    {
        $this->setData(self::UPDATED_AT, $updatedAt);
        return $this;
    }
}
