<?php

namespace Drop\GELProximity\Block\Paypal\Express;

use Drop\GELProximity\Model\Carrier\GELProximity;
use Magento\Paypal\Model\Express\Checkout;

/**
 * Class Review
 * @package Drop\GELProximity\Block\Paypal\Express
 */
class Review extends \Magento\Paypal\Block\Express\Review
{
    /**
     * {@inheritDoc}
     * @override
     */
    protected function _beforeToHtml(): Review
    {
        $methodInstance = $this->_quote->getPayment()->getMethodInstance();
        $this->setPaymentMethodTitle($methodInstance->getTitle());

        $this->setShippingRateRequired(true);
        if ($this->_quote->getIsVirtual()) {
            $this->setShippingRateRequired(false);
        } else {
            // prepare shipping rates
            $this->_address = $this->_quote->getShippingAddress();
            $groups = $this->_address->getGroupedAllShippingRates();
            //Remove GEL Proximity method
            unset($groups[GELProximity::CARRIER_CODE]);

            if ($groups && $this->_address) {
                $this->setShippingRateGroups($groups);
                // determine current selected code & name
                foreach ($groups as $code => $rates) {
                    foreach ($rates as $rate) {
                        if ($this->_address->getShippingMethod() == $rate->getCode()) {
                            $this->_currentShippingRate = $rate;
                            break 2;
                        }
                    }
                }
            }

            $canEditShippingAddress = $this->_quote->getMayEditShippingAddress() && $this->_quote->getPayment()
                    ->getAdditionalInformation(Checkout::PAYMENT_INFO_BUTTON) == 1;
            // misc shipping parameters
            $this->setShippingMethodSubmitUrl(
                $this->getUrl("{$this->_controllerPath}/saveShippingMethod", ['_secure' => true])
            )->setCanEditShippingAddress(
                $canEditShippingAddress
            )->setCanEditShippingMethod(
                $this->_quote->getMayEditShippingMethod()
            );
        }

        $this->setEditUrl(
            $this->getUrl("{$this->_controllerPath}/edit")
        )->setPlaceOrderUrl(
            $this->getUrl("{$this->_controllerPath}/placeOrder", ['_secure' => true])
        );
        return $this;
    }
}
