<?php

namespace Drop\GELProximity\Api;

/**
 * Interface GELShipmentStatusInterface
 * @package Drop\GELProximity\Api
 */
interface GELStatusInterface
{
    /**
     * @const
     * Order statuses from GEL server
     */
    public const ORDER_ERROR = -3;
    public const ORDER_CANCELED = -1;
    public const ORDER_NEW = 0;
    public const ORDER_IMPORTED = 2;

    /**
     * @const
     * Shipment statuses from GEL server
     */
    public const SHIPMENT_ERROR_CONFIRM = -2;
    public const SHIPMENT_CANCELED = -1;
    public const SHIPMENT_VALID = 0;
    public const SHIPMENT_DELIVERED = 1;
    public const SHIPMENT_CONFIRMED = 3;
    public const SHIPMENT_SHIPPED = 4;

    /**
     * @const
     * Labels for order statuses
     */
    public const ORDER_STATUS_LABELS = [
        self::ORDER_ERROR => 'Error',
        self::ORDER_CANCELED => 'Canceled',
        self::ORDER_NEW => 'New',
        self::ORDER_IMPORTED => 'Imported'
    ];

    /**
     * @const
     * Labels for shipment statuses
     */
    public const SHIPMENT_STATUS_LABELS = [
        self::SHIPMENT_ERROR_CONFIRM => 'Error during Confirm',
        self::SHIPMENT_CANCELED => 'Canceled',
        self::SHIPMENT_VALID => 'Valid',
        self::SHIPMENT_DELIVERED => 'Delivered',
        self::SHIPMENT_CONFIRMED => 'Confirmed',
        self::SHIPMENT_SHIPPED => 'Shipped'
    ];
}
