<?php
namespace Drop\GELProximity\Model\Service\Responses;

use Drop\GELProximity\Api\Service\Responses\CurrentPickupPointInterface;
use Drop\GELProximity\Api\Service\Responses\DefaultResponseInterface;
use Magento\Framework\ObjectManagerInterface;

/**
 * Class ResponseObjectFactory
 * @package Drop\GELProximity\Model\Service\Responses
 * @factory
 */
class ResponseObjectFactory
{
    /**
     * @const
     */
    public const DEFAULT_RESPONSE = 'default';
    public const CURRENT_PICKUP_POINT_RESPONSE = 'current_pickup_point';

    /**
     * Object Manager instance
     *
     * @var ObjectManagerInterface
     */
    protected $_objectManager;

    /**
     * Response objects mapping
     *
     * @var string[]
     */
    protected $responseTypes = [
        self::DEFAULT_RESPONSE => DefaultResponseInterface::class,
        self::CURRENT_PICKUP_POINT_RESPONSE => CurrentPickupPointInterface::class
    ];

    /**
     * RemovePickupPointFactory constructor.
     * @param ObjectManagerInterface $objectManager
     */
    public function __construct(
        ObjectManagerInterface $objectManager
    ) {
        $this->_objectManager = $objectManager;
    }

    /**
     * Create class instance with specified parameters
     *
     * @param string $type
     * @param array $data
     * @return DefaultResponse|CurrentPickupPoint
     */
    public function create(string $type, array $data = []): DefaultResponseInterface
    {
        return $this->_objectManager->create(
            $this->responseTypes[$type],
            $data
        );
    }
}
