<?php

namespace Drop\GELProximity\Cron;

use Drop\GELProximity\Api\CronInterface;
use Drop\GELProximity\Service\SyncOrdersStatusService;

/**
 * Class SyncOrdersStatus
 * @package Drop\GELProximity\Cron
 */
class SyncOrdersStatus implements CronInterface
{
    /**
     * @var SyncOrdersStatusService
     */
    protected $service;

    /**
     * ShipOrders constructor.
     * @param SyncOrdersStatusService $service
     */
    public function __construct(SyncOrdersStatusService $service)
    {
        $this->service = $service;
    }

    /**
     * Cron method that loads a collection of orders with the Pending GEL status
     * and synchronize them with the status Processing if exists an invoice and is paid
     *
     * {@inheritDoc}
     */
    public function execute(): void
    {
        $this->service->run();
    }
}
