<?php

namespace Drop\GELProximity\Api;

use Magento\Framework\Model\AbstractModel;

/**
 * Interface GelShipmentResourceInterface
 * @package Drop\GELProximity\Api
 */
interface GelShipmentResourceInterface
{
    /**
     * @param AbstractModel $object
     * @return $this
     */
    public function save(AbstractModel $object);

    /**
     * @param AbstractModel $object
     * @param $value
     * @param string|int|null $field field to load by (defaults to model id)
     * @return $this
     */
    public function load(AbstractModel $object, $value, $field = null);

    /**
     * @param AbstractModel $object
     * @return $this
     */
    public function delete(AbstractModel $object);
}
