define([
    'jquery',
    'ko',
    'Magento_Ui/js/form/form',
    'Magento_Checkout/js/model/quote',
    'mage/translate'
], function ($, ko, Component, quote, $t) {
    'use strict';

    return Component.extend({
        defaults: {
            template: 'Drop_GELProximity/gel-proximity-block'
        },
        componentVisible: ko.observable(false),

        /**
         * Init component
         */
        initialize: function () {
            this._super();
            $(document).on('shippingMethod:selection', this.disableSubmit.bind(this));
            $(document).on('shippingMethod:selection', this.changeLabel.bind(this));
        },

        /**
         * Method used to bind visibility of the component by the selected shipping method
         *
         * @returns {boolean}
         */
        isVisible: function() {
            let shippingMethod = quote.shippingMethod();
            return shippingMethod && shippingMethod['carrier_code'] === 'gelproximity';
        },

        /**
         * Disable shipping address submit if no pickup point is selected and the shipping method is GEL Proximity
         *
         * @param {Event} event
         * @param {Object} shippingMethod
         * @param {string} pickupPointId
         */
        disableSubmit: function (event, shippingMethod, pickupPointId) {
            if (shippingMethod && shippingMethod.carrier_code === 'gelproximity' && pickupPointId === '') {
                $('#shipping-method-buttons-container').find('button[type="submit"][data-role="opc-continue"]').attr('disabled', true);
            } else {
                $('#shipping-method-buttons-container').find('button[type="submit"][data-role="opc-continue"]').attr('disabled', false);
            }
        },

        /**
         * Change default checkout label if the method is GEL Proximity
         *
         * @param {Event} event
         * @param {Object} shippingMethod
         * @param {string} pickupPointId
         */
        changeLabel: function (event, shippingMethod, pickupPointId) {
            if (shippingMethod && shippingMethod.carrier_code === 'gelproximity') {
                $('#shipping div.step-title').text($t('Billing Address'));
            } else {
                $('#shipping div.step-title').text($t('Shipping Address'));
            }
        }
    });
});
