define([
    'jquery',
    'Magento_Checkout/js/model/quote'
], function ($, quote) {
    'use strict';

    return function (target) {
        return target.extend({
            validateShippingInformation: function () {
                if (this.validatePickupPointId()) {
                    return this._super();
                }
                return false;
            },
            validatePickupPointId: function () {
                //Retrieve shipping method and pickup point ID
                let shippingMethod = quote.shippingMethod(),
                    pickupPointId = $('#pickup_point_id').val();
                if (shippingMethod !== null) {
                    //Trigger custom event to show/hide error on the pickup point component
                    $(document.body).trigger(
                        'pickupPointId:validation',
                        [pickupPointId, shippingMethod.method_code]
                    );
                    //Valid only if shipping method is GEL Proximity and a pickup point is selected
                    if (
                        shippingMethod.method_code === 'gelproximity' &&
                        (pickupPointId === null || pickupPointId === '')
                    ) {
                        this.focusInvalid();
                        return false;
                    }
                }
                return true;
            }
        })
    }
});
