<?php

namespace Drop\GELProximity\Observer;

use Drop\GELProximity\Api\OrderStatusInterface;
use Drop\GELProximity\Helper\Data;
use Drop\GELProximity\Model\Carrier\GELProximity;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;

/**
 * Class ChangeOrderStatus
 * @package Drop\GELProximity\Observer
 * @observer
 */
class ChangeOrderStatus implements ObserverInterface
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * ChangeOrderStatus constructor.
     * @param Data $helper
     */
    public function __construct(Data $helper)
    {
        $this->helper = $helper;
    }

    /**
     * Observer method used to change the order status to Processing GEL if the shipping method is GEL Proximity
     *
     * {@inheritDoc}
     */
    public function execute(Observer $observer): void
    {
        if ($this->helper->isModuleEnabled()) {
            //Debug
            $this->helper->logDebug('[OBSERVER_CHANGEORDERSTATUS] Starting changing the order status after the invoice.');
            /** @var Order $order */
            $order = $observer->getData('order');
            //Debug
            $this->helper->logDebug('--- [OBSERVER_CHANGEORDERSTATUS] Processing order ' . $order->getId());
            $shippingMethod = $order->getShippingMethod(true);
            if ($shippingMethod->getData('carrier_code') === GELProximity::CARRIER_CODE) {
                //Debug
                $this->helper->logDebug('------ [OBSERVER_CHANGEORDERSTATUS] Changing status to Processing GEL for order ' . $order->getId());
                $order->setState(OrderStatusInterface::ORDER_STATE_PROCESSING_GEL)
                    ->setStatus(OrderStatusInterface::ORDER_STATUS_PROCESSING_GEL);
            } else {
                //Debug
                $this->helper->logDebug('------ [OBSERVER_CHANGEORDERSTATUS] Not a GEL shipment: skipping.');
            }
        } else {
            //Debug
            $this->helper->logDebug('[OBSERVER_CHANGEORDERSTATUS] Module not enabled: skipping.');
        }
    }
}
