<?php

namespace Drop\GELProximity\Model\Service\Responses;

use Drop\GELProximity\Api\Service\Responses\CurrentPickupPointInterface;

/**
 * Class CurrentPickupPoint
 * @package Drop\GELProximity\Model\Service\Responses
 */
class CurrentPickupPoint extends DefaultResponse implements CurrentPickupPointInterface
{
    /**
     * {@inheritDoc}
     */
    public function getPickupPointData(): ?string
    {
        return $this->_get(self::KEY_PICKUP_POINT_DATA);
    }

    /**
     * {@inheritDoc}
     */
    public function setPickupPointData(string $data): CurrentPickupPointInterface
    {
        $this->setData(self::KEY_PICKUP_POINT_DATA, $data);
        return $this;
    }
}
