<?php

namespace Drop\GELProximity\Cron;

use Drop\GELProximity\Api\CronInterface;
use Drop\GELProximity\Service\CleanService;

/**
 * Class CleanShipments
 * @package Drop\GELProximity\Cron
 */
class CleanShipments implements CronInterface
{
    /**
     * @var CleanService
     */
    protected $service;

    /**
     * CleanShipments constructor.
     * @param CleanService $service
     */
    public function __construct(
        CleanService $service
    ) {
        $this->service = $service;
    }

    /**
     * Cron method that will delete GEL shipments that hasn't got an order and a quote anymore
     *
     * {@inheritDoc}
     */
    public function execute(): void
    {
        $this->service->run();
    }
}
