<?php

namespace Drop\GELProximity\Block\PickupPoint;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Drop\GELProximity\Api\GelShipmentRepositoryInterface;
use Drop\GELProximity\Helper\Data;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\NoSuchEntityException;
use Magento\Framework\Registry;
use Magento\Framework\View\Element\Template;
use Magento\Sales\Model\Order;

/**
 * Class Info
 * @package Drop\GELProximity\Block\PickupPoint
 */
class Info extends Template
{
    /**
     * @var Registry
     */
    protected $coreRegistry;

    /**
     * @var GelShipmentRepositoryInterface
     */
    protected $gelShipmentRepository;

    /**
     * @var GelShipmentInterface
     */
    protected $currentShipment;

    /**
     * @var Data
     */
    protected $helper;

    /**
     * Info constructor.
     * @param Template\Context $context
     * @param Registry $coreRegistry
     * @param GelShipmentRepositoryInterface $gelShipmentRepository
     * @param Data $helper
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        Registry $coreRegistry,
        GelShipmentRepositoryInterface $gelShipmentRepository,
        Data $helper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->coreRegistry = $coreRegistry;
        $this->gelShipmentRepository = $gelShipmentRepository;
        $this->helper = $helper;
    }

    /**
     * Retrieve the current shipment and return if exists
     *
     * @return bool
     */
    public function isGELShipment(): bool
    {
        if ($this->helper->isModuleEnabled()) {
            /** @var Order $order */
            $order = $this->coreRegistry->registry('current_order');
            try {
                $this->currentShipment = $this->gelShipmentRepository->getByQuoteId($order->getQuoteId());
                return true;
            } catch (InputException | NoSuchEntityException $e) {
                //This isn't a GEL Shipment
                return false;
            }
        }
        return false;
    }

    /**
     * Format pickup point additional data
     *
     * @return string
     */
    public function getFormattedPickupPointAddress(): string
    {
        $pickupPointData = $this->helper->unserializeToArray(
            $this->currentShipment->getAdditionalPickupPointData()
        );
        return __(
            'Pickup point N° %1,<br>%2,<br>%3 (%4), %5, %6',
            $this->currentShipment->getPickupPointId(),
            $pickupPointData['address'],
            $pickupPointData['city'],
            $pickupPointData['department'],
            $pickupPointData['zipCode'],
            $pickupPointData['country']
        );
    }
}
