<?php

namespace Drop\GELProximity\Test\Unit\Model;

use Drop\GELProximity\Api\Data\GelShipmentSearchResultInterfaceFactory;
use Drop\GELProximity\Model\GelShipmentFactory;
use Drop\GELProximity\Model\GelShipmentRepository;
use Drop\GELProximity\Model\GelShipment;
use Drop\GELProximity\Model\ResourceModel\GelShipment\CollectionFactory;
use Exception;
use Magento\Framework\Exception\AlreadyExistsException;
use Magento\Framework\Exception\InputException;
use Magento\Framework\Exception\NoSuchEntityException;
use PHPUnit\Framework\TestCase;

/**
 * Class GelShipmentRepositoryTest
 * @package Drop\GELProximity\Test\Unit\Model
 */
class GelShipmentRepositoryTest extends TestCase
{
    /**
     * @var GelShipmentRepository
     */
    protected $gelShipmentRepository;

    /**
     * @var GelShipment
     */
    private $newEntity;

    /**
     * Setup dependency before testing
     * @constructor
     */
    protected function setUp(): void
    {
        $this->newEntity = $this->createMock(GelShipment::class);
        $this->gelShipmentRepository = $this
            ->getMockBuilder(GelShipmentRepository::class)
            ->setConstructorArgs([
                $this->createMock(\Drop\GELProximity\Model\ResourceModel\GelShipment::class),
                $this->createMock(GelShipmentFactory::class),
                $this->createMock(CollectionFactory::class),
                $this->createMock(GelShipmentSearchResultInterfaceFactory::class),
                [1 => $this->newEntity]
            ])
            ->setMethodsExcept(['get', 'save', 'delete'])
            ->getMock();
    }

    /**
     * Test method for @see GelShipmentRepository::get()
     *
     * @test
     * @throws InputException
     * @throws NoSuchEntityException
     */
    public function testGet(): void
    {
        $this->assertInstanceOf(
            GelShipment::class,
            $this->gelShipmentRepository->get(1)
        );
    }

    /**
     * Test method for @see GelShipmentRepository::save()
     *
     * @test
     * @throws AlreadyExistsException
     */
    public function testSave(): void
    {
        $this->assertInstanceOf(
            GelShipment::class,
            $this->gelShipmentRepository->save($this->newEntity)
        );
    }

    /**
     * Test method for @see GelShipmentRepository::delete()
     *
     * @test
     * @throws Exception
     */
    public function testDelete(): void
    {
        $this->assertTrue(
            $this->gelShipmentRepository->delete($this->newEntity)
        );
    }
}
