<?php

namespace Drop\GELProximity\Setup;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Drop\GELProximity\Model\GelShipment;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Quote\Api\Data\CartInterface;
use Magento\Sales\Model\Order;
use Zend_Db_Exception;

/**
 * Class InstallSchema
 * @package Drop\GELProximity\Setup
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritDoc}
     * @throws Zend_Db_Exception
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context): void
    {
        $setup->startSetup();
        $this->installGELModuleTable($setup);
        $setup->endSetup();
    }

    /**
     * @param SchemaSetupInterface $setup
     * @throws Zend_Db_Exception
     */
    protected function installGELModuleTable(SchemaSetupInterface $setup): void
    {
        $table = $setup
            ->getConnection()
            ->newTable(
                $setup->getTable(GelShipmentInterface::TABLE_NAME)
            );
        $table
            ->addColumn(
                GelShipmentInterface::ENTITY_ID,
                Table::TYPE_INTEGER,
                null,
                [
                    'identity' => true,
                    'unsigned' => true,
                    'nullable' => false,
                    'primary' => true
                ],
                'Entity ID'
            )
            ->addColumn(
                GelShipmentInterface::PICKUP_POINT_ID,
                Table::TYPE_INTEGER,
                null,
                [
                    'length' => 10,
                    'unsigned' => true,
                    'nullable' => true,
                ],
                'Pickup Point ID from GEL Proximity'
            )
            ->addColumn(
                GelShipmentInterface::COST,
                Table::TYPE_DECIMAL,
                null,
                [
                    'precision' => 20,
                    'scale' => 4,
                    'nullable' => true,
                    'unsigned' => true
                ],
                'Price of shipment from GEL Proximity'
            )
            ->addColumn(
                GelShipmentInterface::CURRENCY,
                Table::TYPE_TEXT,
                50,
                [],
                'Currency of shipment price from GEL Proximity'
            )
            ->addColumn(
                GelShipmentInterface::QUOTE_REFERENCE,
                Table::TYPE_TEXT,
                50,
                [],
                'Quote ID Mask used for the first API call'
            )
            ->addColumn(
                GelShipmentInterface::QUOTE_ID,
                Table::TYPE_INTEGER,
                null,
                [
                    'length' => 10,
                    'unsigned' => true,
                    'nullable' => true
                ],
                'Quote ID reference'
            )
            ->addColumn(
                GelShipmentInterface::ORDER_ID,
                Table::TYPE_INTEGER,
                null,
                [
                    'length' => 10,
                    'unsigned' => true,
                    'nullable' => true
                ],
                'Order ID reference'
            )
            ->addColumn(
                GelShipment::EXTERNAL_ORDER_ID,
                Table::TYPE_INTEGER,
                null,
                [
                    'length' => 10,
                    'unsigned' => true,
                    'nullable' => true
                ],
                'External order ID reference from GEL proximity'
            )
            ->addColumn(
                GelShipmentInterface::CREATED_AT,
                Table::TYPE_TIMESTAMP,
                null,
                [
                    'unsigned' => true,
                    'nullable' => true,
                    'default' => Table::TIMESTAMP_INIT,
                ],
                'Created at datetime'
            )
            ->addColumn(
                GelShipmentInterface::UPDATED_AT,
                Table::TYPE_TIMESTAMP,
                null,
                [
                    'unsigned' => true,
                    'nullable' => true,
                    'default' => Table::TIMESTAMP_INIT_UPDATE,
                ],
                'Updated at datetime'
            )
            ->addIndex(
                $setup->getIdxName(
                    GelShipmentInterface::TABLE_NAME,
                    GelShipmentInterface::QUOTE_ID
                ),
                GelShipmentInterface::QUOTE_ID
            )
            ->addIndex(
                $setup->getIdxName(
                    GelShipmentInterface::TABLE_NAME,
                    GelShipmentInterface::ORDER_ID
                ),
                GelShipmentInterface::ORDER_ID
            )
            ->addIndex(
                $setup->getIdxName(
                    GelShipmentInterface::TABLE_NAME,
                    GelShipmentInterface::EXTERNAL_ORDER_ID
                ),
                GelShipmentInterface::EXTERNAL_ORDER_ID
            )
            ->addForeignKey(
                $setup->getFkName(
                    GelShipmentInterface::TABLE_NAME,
                    GelShipmentInterface::QUOTE_ID,
                    'quote',
                    CartInterface::KEY_ENTITY_ID
                ),
                GelShipmentInterface::QUOTE_ID,
                'quote',
                CartInterface::KEY_ENTITY_ID,
                Table::ACTION_SET_NULL
            )
            ->addForeignKey(
                $setup->getFkName(
                    GelShipmentInterface::TABLE_NAME,
                    GelShipmentInterface::ORDER_ID,
                    'sales_order',
                    Order::ENTITY_ID
                ),
                GelShipmentInterface::ORDER_ID,
                'sales_order',
                Order::ENTITY_ID,
                Table::ACTION_CASCADE
            );
        if (!$setup->tableExists(GelShipmentInterface::TABLE_NAME)) {
            $setup->getConnection()->createTable($table);
        }
    }
}
