<?php

namespace Drop\GELProximity\Console\Command;

use Drop\GELProximity\Console\AbstractCommand;
use Drop\GELProximity\Service\ShipReturnsService;
use Exception;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Console\Cli;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ShipReturns
 * @package Drop\GELProximity\Console\Command
 */
class ShipReturns extends AbstractCommand
{
    /**
     * @const
     * CLI command name
     */
    public const NAME = 'gel:returns:process';

    /**
     * {@inheritDoc}
     */
    protected function configure()
    {
        $this
            ->setName(self::NAME)
            ->setDescription('Loads a collection of returns in a configured status and approve them to GEL Proximity.');
        parent::configure();
    }

    /**
     * Command method that load a collection of returns with a status configured in backoffice
     * and make a call to process and approve them
     *
     * {@inheritDoc}
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->setAreaCode();
        try {
            /**
             * We should avoid using the object manager directly
             * but with DI throws an exception of "Area code not set"
             * during upgrade/dependency compilation
             */
            $objectManager = ObjectManager::getInstance();
            $service = $objectManager->get(ShipReturnsService::class);
            $returnsProcessed = $service->run();
        } catch (Exception $e) {
            //Probably a remote case, but we'll output it anyway
            $output->writeln('<error>' . $e->getMessage() . '</error>');
            return Cli::RETURN_FAILURE;
        }
        //Notice the user of the returns processed
        if ($returnsProcessed > 0) {
            $output->writeln(
                sprintf(
                    '<info>Processed %s returns.</info>',
                    $returnsProcessed
                )
            );
        } else {
            $output->writeln('<info>No returns were processed.</info>');
        }
        return Cli::RETURN_SUCCESS;
    }
}
