<?php

namespace Drop\GELProximity\Console;

use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Command\Command;

/**
 * Class AbstractCommand
 * @package Drop\GELProximity\Console
 * @abstract
 */
abstract class AbstractCommand extends Command
{
    /**
     * @var State
     */
    protected $state;

    /**
     * AbstractCommand constructor.
     * @param State $state
     * @param string|null $name
     */
    public function __construct(
        State $state,
        string $name = null
    ) {
        $this->state = $state;
        parent::__construct($name);
    }

    /**
     * Set area code before command execution
     *
     * @param string $area
     */
    protected function setAreaCode(string $area = Area::AREA_ADMINHTML): void
    {
        try {
            $this->state->setAreaCode($area);
        } catch (LocalizedException $exception) {
            //Area code is already set
        }
    }
}
