<?php

namespace Drop\GELProximity\Api\Helper;

use Magento\Framework\App\Area;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\MailException;

/**
 * Interface EmailInterface
 * @package Drop\GELProximity\Api\Helper
 */
interface EmailInterface
{
    /**
     * Send email report for GEL response error
     *
     * @param int $orderId
     * @param string $errorMessage
     * @throws LocalizedException
     * @throws MailException
     */
    public function sendErrorReport(int $orderId, string $errorMessage): void;

    /**
     * Send an email
     *
     * @param string $templateId
     * @param array $templateVars
     * @param array $sender
     * @param array $recipients
     * @param string $area
     * @throws LocalizedException
     * @throws MailException
     */
    public function send(
        string $templateId,
        array $templateVars,
        array $sender,
        array $recipients,
        string $area = Area::AREA_ADMINHTML
    ): void;
}
