<?php

namespace Drop\GELProximity\Plugin\Block\Checkout;

use Drop\GELProximity\Helper\Data;
use Magento\Checkout\Model\Session;
use Magento\Framework\Exception\NoSuchEntityException;

/**
 * Class LayoutProcessor
 * @package Drop\GELProximity\Plugin\Block\Checkout
 */
class LayoutProcessor
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * LayoutProcessor constructor.
     * @param Data $helper
     * @param Session $checkoutSession
     */
    public function __construct(
        Data $helper,
        Session $checkoutSession
    ) {
        $this->helper = $helper;
        $this->checkoutSession = $checkoutSession;
    }

    /**
     * Add the GEL proximity section inside shipping method
     *
     * @param \Magento\Checkout\Block\Checkout\LayoutProcessor $subject
     * @param array $jsLayout
     * @return array
     */
    public function afterProcess(
        \Magento\Checkout\Block\Checkout\LayoutProcessor $subject,
        array $jsLayout
    ): array {
        if ($this->helper->isModuleEnabled()) {
            $quoteId = $this->checkoutSession->getQuoteId();
            $pickupPointId = $this->checkoutSession->getData('gel_pickup_point_id');
            $additionalPickupPointData = $this->checkoutSession->getData('gel_additional_pickup_point_data');
            $quoteReference = $quoteId . date('_Ymd');

            //Debug
            $this->helper->logDebug('[PLUGIN_LAYOUTPROCESSOR] Adding GEL button in checkout for quote ID ' . $quoteId);

            //Add GEL Button
            $this->helper->addGELButtonToCheckout($jsLayout, $quoteReference, $pickupPointId, $additionalPickupPointData);
            //Add GEL review in payment selection page
            $this->helper->addGELInfoToCheckout($jsLayout, $additionalPickupPointData);
        } else {
            //Debug
            $this->helper->logDebug('[PLUGIN_LAYOUTPROCESSOR] Module not enabled: skipping.');
        }
        return $jsLayout;
    }
}
