<?php

namespace Drop\GELProximity\Helper;

use Drop\GELProximity\Api\Helper\MaskedQuoteIdToQuoteIdInterface;
use Magento\Quote\Api\CartRepositoryInterface;
use Magento\Quote\Model\QuoteIdMaskFactory;
use Magento\Quote\Model\ResourceModel\Quote\QuoteIdMask;

/**
 * Class MaskedQuoteIdToQuoteId
 * @package Drop\GELProximity\Helper
 */
class MaskedQuoteIdToQuoteId implements MaskedQuoteIdToQuoteIdInterface
{
    /**
     * @var CartRepositoryInterface
     */
    protected $cartRepository;

    /**
     * @var QuoteIdMaskFactory
     */
    protected $quoteIdMaskFactory;

    /**
     * @var QuoteIdMask
     */
    protected $quoteIdMaskResource;

    /**
     * MaskedQuoteIdToQuoteId constructor.
     * @param CartRepositoryInterface $cartRepository
     * @param QuoteIdMaskFactory $quoteIdMaskFactory
     * @param QuoteIdMask $quoteIdMaskResource
     */
    public function __construct(
        CartRepositoryInterface $cartRepository,
        QuoteIdMaskFactory $quoteIdMaskFactory,
        QuoteIdMask $quoteIdMaskResource
    ) {
        $this->cartRepository = $cartRepository;
        $this->quoteIdMaskFactory = $quoteIdMaskFactory;
        $this->quoteIdMaskResource = $quoteIdMaskResource;
    }

    /**
     * {@inheritDoc}
     */
    public function execute(string $maskedQuoteId): int
    {
        $quoteIdMask = $this->quoteIdMaskFactory->create();
        $this->quoteIdMaskResource->load($quoteIdMask, $maskedQuoteId, 'masked_id');

        $cart = $this->cartRepository->get($quoteIdMask->getQuoteId());
        /* Check the quote exists to avoid database constraint issues */
        return (int)$cart->getId();
    }
}
