<?php

namespace Drop\GELProximity\Block\Adminhtml\Rma\Edit\Form;

use Drop\GELProximity\Api\Data\GelShipmentInterface;
use Mirasvit\Rma\Model\ResourceModel\Rma\CollectionFactory as RmaCollectionFactory;

class GeneralInfo extends \Mirasvit\Rma\Block\Adminhtml\Rma\Edit\Form\GeneralInfo
{
    /**
     * @var \Mirasvit\Rma\Block\Adminhtml\Rma\Edit\Form\Generalinfo\CustomFields
     */
    private $customFields;
    /**
     * @var \Mirasvit\Rma\Api\Config\RmaNumberConfigInterface
     */
    private $rmaNumberConfig;
    /**
     * @var \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface
     */
    private $rmaManagement;
    /**
     * @var \Mirasvit\Rma\Api\Service\Rma\RmaOrderInterface
     */
    private $rmaOrderService;
    /**
     * @var \Mirasvit\Rma\Helper\User\Html
     */
    private $rmaUserHtml;
    /**
     * @var \Mirasvit\Rma\Helper\Rma\Url
     */
    private $rmaUrl;
    /**
     * @var \Mirasvit\Rma\Helper\Rma\Option
     */
    private $rmaOption;
    /**
     * @var \Mirasvit\Rma\Api\Service\Status\StatusManagementInterface
     */
    private $statusManagement;
    /**
     * @var \Mirasvit\Rma\Helper\Store
     */
    private $storeHelper;
    /**
     * @var \Magento\Framework\Data\FormFactory
     */
    private $formFactory;
    /**
     * @var \Magento\Framework\Convert\DataObject
     */
    private $convertDataObject;
    /**
     * @var RmaCollectionFactory
     */
    private $rmaCollectionFactory;

    /**
     * GeneralInfo constructor.
     * @param \Mirasvit\Rma\Block\Adminhtml\Rma\Edit\Form\Generalinfo\CustomFields $customFields
     * @param \Mirasvit\Rma\Api\Config\RmaNumberConfigInterface $rmaNumberConfig
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement
     * @param \Mirasvit\Rma\Api\Service\Rma\RmaOrderInterface $rmaOrderService
     * @param \Mirasvit\Rma\Api\Service\Status\StatusManagementInterface $statusManagement
     * @param \Mirasvit\Rma\Helper\User\Html $rmaUserHtml
     * @param \Mirasvit\Rma\Helper\Rma\Url $rmaUrl
     * @param \Mirasvit\Rma\Helper\Rma\Option $rmaOption
     * @param \Mirasvit\Rma\Helper\Store $storeHelper
     * @param \Magento\Framework\Data\FormFactory $formFactory
     * @param \Magento\Framework\Convert\DataObject $convertDataObject
     * @param \Magento\Backend\Block\Widget\Context $context
     * @param array $data
     */
    public function __construct(
        \Mirasvit\Rma\Block\Adminhtml\Rma\Edit\Form\Generalinfo\CustomFields $customFields,
        \Mirasvit\Rma\Api\Config\RmaNumberConfigInterface $rmaNumberConfig,
        \Mirasvit\Rma\Api\Service\Rma\RmaManagementInterface $rmaManagement,
        \Mirasvit\Rma\Api\Service\Rma\RmaOrderInterface $rmaOrderService,
        \Mirasvit\Rma\Api\Service\Status\StatusManagementInterface $statusManagement,
        \Mirasvit\Rma\Helper\User\Html $rmaUserHtml,
        \Mirasvit\Rma\Helper\Rma\Url $rmaUrl,
        \Mirasvit\Rma\Helper\Rma\Option $rmaOption,
        \Mirasvit\Rma\Helper\Store $storeHelper,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Framework\Convert\DataObject $convertDataObject,
        \Magento\Backend\Block\Widget\Context $context,
        RmaCollectionFactory $rmaCollectionFactory,
        array $data = []
    ) {
        $this->customFields           = $customFields;
        $this->rmaNumberConfig        = $rmaNumberConfig;
        $this->rmaManagement          = $rmaManagement;
        $this->rmaOrderService        = $rmaOrderService;
        $this->rmaUserHtml            = $rmaUserHtml;
        $this->rmaUrl                 = $rmaUrl;
        $this->rmaOption              = $rmaOption;
        $this->statusManagement       = $statusManagement;
        $this->storeHelper            = $storeHelper;
        $this->formFactory            = $formFactory;
        $this->convertDataObject      = $convertDataObject;
        $this->rmaCollectionFactory = $rmaCollectionFactory;

        parent::__construct($customFields, $rmaNumberConfig, $rmaManagement, $rmaOrderService, $statusManagement, $rmaUserHtml, $rmaUrl, $rmaOption, $storeHelper, $formFactory, $convertDataObject, $context);
    }

    /**
     * General information form
     *
     * @param \Mirasvit\Rma\Api\Data\RmaInterface $rma
     *
     * @return string
     */
    public function getGeneralInfoFormHtml(\Mirasvit\Rma\Api\Data\RmaInterface $rma)
    {
        $form = $this->formFactory->create();
        /** @var \Magento\Framework\Data\Form\Element\Fieldset $fieldset */
        $fieldset = $form->addFieldset('edit_fieldset', []);

        if ($rma->getId()) {
            $fieldset->addField('rma_id', 'hidden', [
                'name'  => 'rma_id',
                'value' => $rma->getId(),
            ]);
        }

        if($this->isGelRma($rma)) {
            $str = '<b>' . __('Return sent to GEL Proximity') . '</b>';

            $fieldset->addField('is_gel_rma', 'note', [
                'name'  => 'is_gel_rma',
                'label' => __(''),
                'text' => $str,
            ]);
        }

        if ($this->rmaNumberConfig->isManualNumberAllowed()) {
            $element = $fieldset->addField('increment_id', 'text', [
                'label' => __('RMA #'),
                'name'  => 'increment_id',
                'value' => $rma->getIncrementId(),
            ]);

            if (!$rma->getId()) {
                $element->setNote('will be generated automatically, if empty');
            }
        }

        $orders = $this->rmaManagement->getOrders($rma);
        if (!$orders && !$rma->getId()) {
            $customerId = (int)$this->getRequest()->getParam('customer_id');
            $fieldset->addField('is_offline', 'hidden', [
                'name'   => 'is_offline',
                'value'  => 1,
            ]);
            $fieldset->addField('customer_id', 'hidden', [
                'name'   => 'customer_id',
                'value'  => $customerId,
            ]);
            $fieldset->addField('store_id', 'select', [
                'name'   => 'store_id',
                'value'  => 1,
                'label'  => __('Store View'),
                'values' => $this->storeHelper->getCoreStoreOptionArray(),
            ]);
        } elseif ($orders) {
            $str = '';
            foreach ($orders as $order) {
                $str .= '<div>';
                if ($order->getIsOffline()) {
                    $str .= $this->escapeHtml($order->getReceiptNumber());
                } else {
                    if ($order) {
                        $url  = $this->getUrl('sales/order/view', ['order_id' => $order->getId()]);
                        $str .= '<a href="' . $url . '" target="_blank">#' . $order->getIncrementId() . '</a><br/>';
                    } else {
                        $str .= __('Removed Order');
                    }
                }
                $str .= '</div>';
            }
            $fieldset->addField('order_id', 'note', [
                'name'  => 'order_id',
                'label' => __('Order #'),
                'text' => $str,
            ]);
        }

        if ($rma->getTicketId()) {
            $fieldset->addField('ticket_id', 'hidden', [
                'name'  => 'ticket_id',
                'value' => $rma->getTicketId(),
            ]);
            $ticket = $this->rmaManagement->getTicket($rma);
            $fieldset->addField('ticket_link', 'link', [
                'label'  => __('Created From Ticket'),
                'name'   => 'ticket_link',
                'value'  => '#' . $ticket->getCode(),
                'href'   => $ticket->getBackendUrl(),
                'target' => '_blank',
            ]);
        }

        $fieldset->addField('user_id', 'select', [
            'label'  => __('RMA Owner'),
            'name'   => 'user_id',
            'value'  => $rma->getUserId(),
            'values' => $this->rmaUserHtml->toAdminUserOptionArray(true),
        ]);

        // if edit page and customer created tree
        if ($rma->getStatusId() && $this->statusManagement->isStatusTreeUsed()) {
            $options = $this->convertDataObject->toOptionArray(
                $this->rmaOption->getNextStatusList($rma->getStatusId()), "id", "name"
            );
        } else { // show all statuses for new RMA
            $options = $this->convertDataObject->toOptionArray($this->rmaOption->getStatusList(), "id", "name");
        }
        $fieldset->addField('status_id', 'select', [
            'label' => __('Status'),
            'name' => 'status_id',
            'value' => $rma->getStatusId(),
            'values' => $options
        ]);

        $fieldset->addField('return_label', 'Mirasvit\Rma\Block\Adminhtml\Rma\Edit\Form\Element\File', [
            'label'      => __('Upload Return Label'),
            'name'       => 'return_label',
            'attachment' => $this->rmaManagement->getReturnLabel($rma),
        ]);

        if ($rma->getId()) {
            $fieldset->addField('guest_link', 'link', [
                'label'  => __('External Link'),
                'name'   => 'guest_link',
                'class'  => 'guest-link',
                'value'  => __('open'),
                'href'   => $this->rmaUrl->getGuestUrl($rma),
                'target' => '_blank',
            ]);
            $html = $this->getOtherRmasHtml($rma);
            if ($html) {
                $fieldset->addField('other_rmas', 'note', [
                    'label' => __('Other RMAs'),
                    'name'  => 'other_rmas',
                    'class' => 'other-rmas',
                    'text'  => $html,
                ]);
            }
        }

        $this->customFields->addExchangeOrders($fieldset, $rma);
        $this->customFields->addCreditmemos($fieldset, $rma);

        $this->customFields->getReturnAddress($fieldset, $rma);

        return $form->toHtml();
    }


    /**
     * Check if rma is GEL shipment associated
     *
     * @return bool
     */
    private function isGelRma($rma): bool
    {
        $collection = $this->rmaCollectionFactory
            ->create()
            ->addFieldToFilter(
                'main_table.rma_id',
                ['EQ' => $rma->getId()]
            );

        $collection
            ->getSelect()
            ->joinLeft(
                ['gps' => $collection->getTable(GelShipmentInterface::TABLE_NAME)],
                'gps.' . GelShipmentInterface::ORDER_ID . ' = ' . $rma->getOrderId()
            )
            ->where(
                'gps.'. GelShipmentInterface::IS_RETURN . '=1'
            );

        return count($collection) > 0;
    }
}