<?php

namespace Drop\GELProximity\Console\Command;

use Drop\GELProximity\Console\AbstractCommand;
use Drop\GELProximity\Service\SyncOrdersStatusService;
use Exception;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Console\Cli;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class SyncOrdersStatus
 * @package Drop\GELProximity\Console\Command
 */
class SyncOrdersStatus extends AbstractCommand
{
    /**
     * @const
     * CLI command name
     */
    public const NAME = 'gel:orders-status:sync';

    /**
     * {@inheritDoc}
     */
    protected function configure()
    {
        $this
            ->setName(self::NAME)
            ->setDescription('Synchronize the status of all the orders in status Pending that should be in Processing (like PayPal orders).');
        parent::configure();
    }

    /**
     * Command method that sync all the orders with the wrong status (like PayPal orders)
     *
     * {@inheritDoc}
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $this->setAreaCode();
        try {
            /**
             * We should avoid using the object manager directly
             * but with DI throws an exception of "Area code not set"
             * during upgrade/dependency compilation
             */
            $objectManager = ObjectManager::getInstance();
            $service = $objectManager->get(SyncOrdersStatusService::class);
            $synchronizedOrders = $service->run();
        } catch (Exception $e) {
            //Probably a remote case, but we'll output it anyway
            $output->writeln('<error>' . $e->getMessage() . '</error>');
            return Cli::RETURN_FAILURE;
        }
        //Notice the user of the synchronized orders
        if ($synchronizedOrders > 0) {
            $output->writeln(
                sprintf(
                    '<info>Synchronized %s orders.</info>',
                    $synchronizedOrders
                )
            );
        } else {
            $output->writeln('<info>No orders were synchronized.</info>');
        }
        return Cli::RETURN_SUCCESS;
    }
}
