<?php

namespace Drop\GELProximity\Api\Service;

use InvalidArgumentException;
use Zend\Http\Client;
use Zend\Http\Response;
use Magento\Framework\Exception\AuthenticationException;

/**
 * Interface GelGatewayInterface
 * @package Drop\GELProximity\Api\Service
 */
interface GelGatewayInterface
{
    /**
     * Request to GEL Proximity server to retrieve a valid token
     * that will be used to call their APIs
     *
     * @return void
     * @throws AuthenticationException
     */
    public function authenticate();

    /**
     * Request to GEL Proximity server to confirm an order
     *
     * @param string $url
     * @param array $data
     * @return array
     * @throws InvalidArgumentException
     */
    public function confirmOrder(string $url, array $data): array;

    /**
     * Request to GEL Proximity server to retrieve the status of the order's shipment
     *
     * @param string $url
     * @param array $data
     * @return array
     * @throws AuthenticationException
     * @throws InvalidArgumentException
     */
    public function getOrderStatus(string $url, array $data): array;

    /**
     * Request to GEL Proximity server to download the shipping packaging label for the return
     *
     * @param string $url
     * @param array $data
     * @throws AuthenticationException
     * @throws InvalidArgumentException
     * @return array
     */
    public function downloadShippingPackaging(string $url, array $data): array;

    /**
     * Do a POST request to the GEL proximity server
     *
     * @param string $url
     * @param string $action
     * @param string $body
     * @param string $contentType
     * @return Response
     */
    public function post(
        string $url,
        string $action,
        string $body,
        string $contentType = Client::ENC_URLENCODED
    ): Response;

    /**
     * Do a GET request to the GEL proximity server
     *
     * @param string $url
     * @param string $action
     * @param array|null $params
     * @return Response
     */
    public function get(string $url, string $action, ?array $params): Response;
}
