define([
    'uiComponent',
    'ko',
    'jquery',
    'Magento_Checkout/js/model/quote'
], function (Component, ko, $, quote) {
    'use strict';

    return Component.extend({
        defaults: {
            pickupPointData: ''
        },
        pickupPointAddress: '',

        /**
         * @constructor
         */
        initialize: function () {
            this._super();
            this.pickupPointAddress = ko.observable(
                this.formatAddress(
                    JSON.parse(this.pickupPointData)
                )
            );
            //Bind pickup point address selection custom event to component private function
            $(document).on('pickupPointId:selection', this._triggerPickupPointSelection.bind(this));
        },

        /**
         * Returns if the shipment is GEL and a pickup point is selected
         *
         * @returns {boolean}
         */
        isGELShipment: function () {
            let shippingMethod = quote.shippingMethod();
            let pickupPointId = $('#pickup_point_id').val();
            return pickupPointId && shippingMethod && shippingMethod['carrier_code'] === 'gelproximity';
        },

        /**
         * Format pickup point address
         *
         * @param {Object|null} addressData
         * @returns {string}
         */
        formatAddress: function (addressData) {
            if (addressData !== null) {
                return '%1, %2 (%3), %4, %5'
                    .replace('%1', addressData.address)
                    .replace('%2', addressData.city)
                    .replace('%3', addressData.department)
                    .replace('%4', addressData.zipCode)
                    .replace('%5', addressData.country);
            }
            return '';
        },

        /**
         * Set pickup point address from the GEL callback
         *
         * @param {Event} event
         * @param {Object} pickupPointData
         * @private
         */
        _triggerPickupPointSelection: function (event, pickupPointData) {
            this.pickupPointData = pickupPointData;
            this.pickupPointAddress(this.formatAddress(pickupPointData));
        }
    });
});
