<?php

namespace Drop\GELProximity\Service;

use Drop\GELProximity\Api\GelShipmentRepositoryInterface;
use Drop\GELProximity\Api\Service\GelGatewayInterface;
use Drop\GELProximity\Api\Service\Processors\OrderProcessorInterface;
use Drop\GELProximity\Api\Service\ServiceInterface;
use Drop\GELProximity\Helper\Data;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;

/**
 * Class AbstractService
 * @package Drop\GELProximity\Service
 */
abstract class AbstractService implements ServiceInterface
{
    /**
     * @var Data
     */
    protected $helper;

    /**
     * @var GelShipmentRepositoryInterface
     */
    protected $gelShipmentRepository;

    /**
     * @var GelGatewayInterface
     */
    protected $gateway;

    /**
     * @var OrderProcessorInterface
     */
    protected $orderProcessor;

    /**
     * AbstractService constructor.
     * @param Data $helper
     * @param GelShipmentRepositoryInterface $gelShipmentRepository
     * @param GelGatewayInterface $gateway
     * @param OrderProcessorInterface $orderProcessor
     */
    public function __construct(
        Data $helper,
        GelShipmentRepositoryInterface $gelShipmentRepository,
        GelGatewayInterface $gateway,
        OrderProcessorInterface $orderProcessor
    ) {
        $this->helper = $helper;
        $this->gelShipmentRepository = $gelShipmentRepository;
        $this->gateway = $gateway;
        $this->orderProcessor = $orderProcessor;
    }

    /**
     * {@inheritDoc}
     */
    public function canBeExecuted(): bool
    {
        return $this->helper->isModuleEnabled();
    }

    /**
     * Method that will initialize the collection of the service class
     *
     * @abstract
     * @return AbstractCollection
     */
    abstract protected function initServiceCollection(): AbstractCollection;
}
