<?php

namespace Drop\GELProximity\Cron;

use Drop\GELProximity\Api\CronInterface;
use Drop\GELProximity\Service\TrackService;

/**
 * Class TrackOrders
 * @package Drop\GELProximity\Cron
 */
class TrackOrders implements CronInterface
{
    /**
     * @var TrackService
     */
    protected $service;

    /**
     * TrackOrders constructor.
     * @param TrackService $service
     */
    public function __construct(TrackService $service)
    {
        $this->service = $service;
    }

    /**
     * Cron method that load a collection of order with the Sent to GEL status
     * and make a call to track and change their status based on the current tracking status
     *
     * {@inheritDoc}
     */
    public function execute(): void
    {
        $this->service->run();
    }
}
