<?php


namespace Drop\Gdpr\Setup;

use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Customer\Model\Customer;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Customer\Setup\CustomerSetupFactory;
use Magento\Framework\Setup\UpgradeDataInterface;

class UpgradeData implements UpgradeDataInterface
{

    private $customerSetupFactory;

    /**
     * Constructor
     *
     * @param \Magento\Customer\Setup\CustomerSetupFactory $customerSetupFactory
     */
    public function __construct(
        CustomerSetupFactory $customerSetupFactory
    ) {
        $this->customerSetupFactory = $customerSetupFactory;
    }

    /**
     * {@inheritdoc}
     */
    public function upgrade(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $customerSetup = $this->customerSetupFactory->create(['setup' => $setup]);

        if (version_compare($context->getVersion(), "1.0.0", "<")) {
        
            $customerSetup->addAttribute(\Magento\Customer\Model\Customer::ENTITY, 'profiling_acceptance', [
                'type' => 'int',
                'label' => 'Profiling',
                'input' => 'boolean',
                'source' => '',
                'required' => true,
                'visible' => true,
                'position' => 200,
                'system' => false,
                'backend' => ''
            ]);
            
            $attribute = $customerSetup->getEavConfig()->getAttribute('customer', 'profiling_acceptance')
            ->addData(['used_in_forms' => [
                    'customer_account_create',
                    'customer_account_edit'
                ]
            ]);
            $attribute->save();
        }

        $setup->startSetup();
        if (version_compare($context->getVersion(), "1.0.0", "<")) {
            //Your upgrade script
        }
        $setup->endSetup();
    }
}
