var myErrorCheckoutContainer;

define(
	[
		'ko',
		'uiComponent',
		'underscore',
		'Magento_Checkout/js/model/step-navigator',
		'Magento_Customer/js/model/customer',
		'jquery',
		'mage/translate',
		'Magento_Ui/js/model/messages',
		'uiLayout',
	],
	function (
		ko,
		Component,
		_,
		stepNavigator,
		customer,
		$,
		$t,
		Messages,
		layout
	) {
		'use strict';

		return Component.extend({
			defaults: {
				template: 'Drop_FourStepsCheckout/review-step'
			},

			//add here your logic to display step,
			isVisible: ko.observable(true),

			/**
			 *
			 * @returns {*}
			 */
			initialize: function () {
				this._super().initChildren();
				// register your step
					//this.setLoginTemplate();
					stepNavigator.registerStep(
						//step code will be used as step content id in the component template
						'final-review',
						//step alias
						null,
						//step title value
						$t('Confirmation'),
						//observable property with logic when display step or hide step
						this.isVisible,



						_.bind(this.navigate, this),

						/**
						 * sort order value
						 * 'sort order value' < 10: step displays before shipping step;
						 * 10 < 'sort order value' < 20 : step displays between shipping and payment step
						 * 'sort order value' > 20 : step displays after payment step
						 */
						30
					);

					self = this;

				// $(window).on("step:change", function(event, code){
				// 	console.log("CAMBIATO PASSO", code);
				//
				// 	if (code=="payment"){
				// 		self.restoreButton();
				// 	}
				// });

				return this;
			},

			/**
			 * The navigate() method is responsible for navigation between checkout step
			 * during checkout. You can add custom logic, for example some conditions
			 * for switching to your custom step
			 * When the user navigates to the custom step via url anchor or back button we_must show step manually here
			 */
			navigate: function () {
				this.isVisible(true);

			},

			/**
			 * @returns void
			 */
			navigateToNextStep: function () {
				stepNavigator.next();
			},
			placeorder: function(){
				$('.payment-method._active .primary button.checkout').trigger('click');
			},

			back: function() {
				stepNavigator.navigateTo('shipping');
			},
			backbilling: function() {
				this.restoreButton();
				stepNavigator.navigateTo('payment');
			},
			restoreButton: function(){
				$('.payment-method._active .primary button.checkout').removeClass("disabled");
			},

			/**
			 * Initialize child elements
			 *
			 * @returns {Component} Chainable.
			 */
			initChildren: function () {
				this.messageContainer = new Messages();
				this.createMessagesComponent();

				return this;
			},

			/**
			 * Create child message renderer component
			 *
			 * @returns {Component} Chainable.
			 */
			createMessagesComponent: function () {

				var messagesComponent = {
					parent: this.name,
					name: this.name + '.messages',
					displayArea: 'messages',
					component: 'Magento_Ui/js/view/messages',
					config: {
						messageContainer: this.messageContainer
					}
				};

				myErrorCheckoutContainer = this.messageContainer;

				layout([messagesComponent]);

				return this;
			},
		});
	}
);