<?php

namespace Drop\FourStepsCheckout\Plugin\MSP\ReCaptcha\LayoutProcessor\Checkout;

/**
 * Onepage class
 */
class Onepage
{
    /**
     * @var \MSP\ReCaptcha\Model\LayoutSettings
     */
    protected $_layoutSettings;

    /**
     * @var \MSP\ReCaptcha\Model\Config
     */
    protected $_config;

    /**
     * @param \MSP\ReCaptcha\Model\LayoutSettings $layoutSettings
     * @param \MSP\ReCaptcha\Model\Config         $config
     */
    public function __construct(
        \MSP\ReCaptcha\Model\LayoutSettings $layoutSettings,
        \MSP\ReCaptcha\Model\Config         $config
    ) {
        $this->_layoutSettings = $layoutSettings;
        $this->_config         = $config;
    }

    /**
     * Hook before
     * @param  \EasyNolo\BancaSellaPro\Model\WS\CryptDecrypt $subjet
     * @param  array                                         $params
     * @return array
     */
    public function beforeProcess(
        \MSP\ReCaptcha\Block\LayoutProcessor\Checkout\Onepage $subject,
                                                              $jsLayout
    ) {
        if ($this->_config->isEnabledFrontend()) {
            $jsLayout['components']['checkout']['children']
            ['steps']['children']['login-step']
            ['children']['authentication']['children']
            ['msp_recaptcha']['settings'] = $this->_layoutSettings->getCaptchaSettings();
        }

        if ( ! $this->_config->isEnabledFrontend()) {
            if (isset($jsLayout['components']['checkout']['children']
                ['steps']['children']['login-step']
                ['children']['authentication']['children']
                ['msp_recaptcha']['settings'])) {
                unset($jsLayout['components']['checkout']['children']
                    ['steps']['children']['login-step']
                    ['children']['authentication']['children']
                    ['msp_recaptcha']['settings']);
            }
        }

        return array($jsLayout);
    }
}
