/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
	'jquery',
	'uiComponent',
	'Magento_Checkout/js/model/quote',
	'Magento_Checkout/js/model/step-navigator',
	'ko'
], function ($, Component, quote, stepNavigator, ko) {
	'use strict';


	return Component.extend({
		defaults: {
			template: 'Drop_FourStepsCheckout/summary/review'
		},

		isVisible: function () {
			return !quote.isVirtual() && stepNavigator.isProcessed('payment');
		},

		getShippingAddress: function(){
			var address = quote.shippingAddress();
			var html = "";
			if (address) {
				html = this.formatAddress(address);
			}
			return html


		},

		getBillingAddress: function(){
			var address = quote.billingAddress();

			var html = "";

			if (address) {
				html = this.formatAddress(address);
			}
			return html
		},

		getShippingMethod: function () {
			var shipping = quote.shippingMethod();

			if (shipping) {
				return shipping.method_title
			}


			return "";
		},

		getPaymentMethod: function(){
			var method =  quote.paymentMethod();

			if (method) {
				return method.method
			}
			return "";
		},

		backToShippingAddress: function(){
			stepNavigator.navigateTo('shipping', 'opc-shipping_method');
		},

		backToPaymentMethod: function () {
			stepNavigator.navigateTo('payment', 'opc-shipping_method');
		},

		formatAddress(address) {
			var html = "<strong>" + address.firstname + " " + address.lastname + "</strong>";
			html+= address.street + "<br/>";
			if (address.street1){
				html+= address.street1 + "<br/>";
			}
			html+= address.city + ", " + address.region + " " + address.postcode + "<br/>";
			//html+= address.country + "<br/>";
			html+= address.telephone + "<br/>";

			return html
		}
	});


});
