/**
 *                       ######
 *                       ######
 * ############    ####( ######  #####. ######  ############   ############
 * #############  #####( ######  #####. ######  #############  #############
 *        ######  #####( ######  #####. ######  #####  ######  #####  ######
 * ###### ######  #####( ######  #####. ######  #####  #####   #####  ######
 * ###### ######  #####( ######  #####. ######  #####          #####  ######
 * #############  #############  #############  #############  #####  ######
 *  ############   ############  #############   ############  #####  ######
 *                                      ######
 *                               #############
 *                               ############
 *
 * Adyen Payment module (https://www.adyen.com/)
 *
 * Copyright (c) 2015 Adyen BV (https://www.adyen.com/)
 * See LICENSE.txt for license details.
 *
 * Author: Adyen <magento@adyen.com>
 */
define(
    [
        'ko',
        'jquery',
        'Magento_Customer/js/model/customer',
        'Magento_Checkout/js/model/payment/additional-validators',
        'Magento_Checkout/js/model/quote',
        'Magento_Checkout/js/model/step-navigator',
        'Magento_Checkout/js/action/place-order',
        'Magento_Checkout/js/model/full-screen-loader',
        'mage/url'

    ],
    function (ko, $, customer, additionalValidators, quote, stepNavigator, placeOrderAction, fullScreenLoader, url) {
        'use strict';

        var extendAction = {
            placeRedirectOrder: function(data) {

                // Place Order but use our own redirect url after
                var self = this;
                var brandCode = ko.observable(null);



                var paymentStep = false;

                if (stepNavigator.getActiveItemIndex() == 1 && customer.isLoggedIn()) {
                    paymentStep = true
                }
                if (stepNavigator.getActiveItemIndex() == 2 && !customer.isLoggedIn()) {
                    paymentStep = true
                }

                if (paymentStep) {

                    console.log("PAGAMENTO");
                    if (this.validate() && additionalValidators.validate()) {
                        this.isPlaceOrderActionAllowed(false);

                        this.getPlaceOrderDeferredObject()
                            .fail(
                                function () {
                                    self.isPlaceOrderActionAllowed(true);
                                }
                            ).done(
                            function () {
                                self.isPlaceOrderActionAllowed(false);
                                fullScreenLoader.stopLoader();
                                $(".action.primary.checkout").removeClass('disabled');
                                stepNavigator.next();
                            }
                        );

                        return true;
                    }

                }else{
                    console.log("REVIEW");
                    fullScreenLoader.startLoader();
                    var messageContainer = this.messageContainer;
                    if (brandCode()) {
                        messageContainer = self.messageComponents['messages-' + brandCode()];
                    }

                    $('.hpp-message').slideUp();

                    this.isPlaceOrderActionAllowed(false);
                    $.when(
                        placeOrderAction(data, messageContainer)
                    ).fail(
                        function (response) {
                            fullScreenLoader.stopLoader();
                            if (!!response['responseJSON'].parameters) {
                                $("#messages-" + brandCode()).text((response['responseJSON'].message).replace('%1', response['responseJSON'].parameters[0])).slideDown();
                            } else {
                                $("#messages-" + brandCode()).text(response['responseJSON'].message).slideDown();
                            }

                            setTimeout(function () {
                                $("#messages-" + brandCode()).slideUp();
                            }, 10000);
                            self.isPlaceOrderActionAllowed(true);
                        }
                    ).done(
                        function () {
                            self.afterPlaceOrder();
                            $.mage.redirect(
                                window.checkoutConfig.payment[quote.paymentMethod().method].redirectUrl
                            );
                        }
                    )

                }
            }
        }

        return function (placeRedirectOrder) {
            return placeRedirectOrder.extend(extendAction);
        };
    });