/**
 *                       ######
 *                       ######
 * ############    ####( ######  #####. ######  ############   ############
 * #############  #####( ######  #####. ######  #############  #############
 *        ######  #####( ######  #####. ######  #####  ######  #####  ######
 * ###### ######  #####( ######  #####. ######  #####  #####   #####  ######
 * ###### ######  #####( ######  #####. ######  #####          #####  ######
 * #############  #############  #############  #############  #####  ######
 *  ############   ############  #############   ############  #####  ######
 *                                      ######
 *                               #############
 *                               ############
 *
 * Adyen Payment module (https://www.adyen.com/)
 *
 * Copyright (c) 2015 Adyen BV (https://www.adyen.com/)
 * See LICENSE.txt for license details.
 *
 * Author: Adyen <magento@adyen.com>
 */
define(
	[
		'jquery',
		'Magento_Customer/js/model/customer',
		'Magento_Checkout/js/model/payment/additional-validators',
		'Magento_Checkout/js/model/quote',
		'Magento_Checkout/js/model/step-navigator',
		'Magento_Checkout/js/action/place-order',
		'Magento_Checkout/js/model/full-screen-loader',
		'mage/url'

	],
	function ($, customer, additionalValidators, quote, stepNavigator, ActionPlaceOrder, fullScreenLoader, url) {
		'use strict';

		var extendAction = {

			getPlaceOrderDeferredObject: function () {

				return $.when(
					ActionPlaceOrder(this.getData(), myErrorCheckoutContainer)
				);
			},

			placeOrder: function (data, event) {

				var self = this;

				if (event) {
					event.preventDefault();
				}

				var paymentStep = false;

				if (stepNavigator.getActiveItemIndex() == 1 && customer.isLoggedIn()) {
					paymentStep = true
				}
				if (stepNavigator.getActiveItemIndex() == 2 && !customer.isLoggedIn()) {
					paymentStep = true
				}

				if (paymentStep) {
					if (this.validate() && additionalValidators.validate()) {
						this.isPlaceOrderActionAllowed(false);

						this.getPlaceOrderDeferredObject()
							.fail(
								function () {
									self.isPlaceOrderActionAllowed(true);
								}
							).done(
							function () {
								self.isPlaceOrderActionAllowed(false);
								fullScreenLoader.stopLoader();
								$(".action.primary.checkout").removeClass('disabled');
								stepNavigator.next();
							}
						);

						return true;
					}
				} else {
					if (this.validate() && additionalValidators.validate()) {
						this.isPlaceOrderActionAllowed(false);

						this.getPlaceOrderDeferredObject()
							.fail(
								function () {
									self.isPlaceOrderActionAllowed(true);
								}
							).done(
							function () {
								self.afterPlaceOrder();

								if (self.redirectAfterPlaceOrder) {
									// use custom redirect Link for supporting 3D secure
									window.location.replace(url.build(window.checkoutConfig.payment[quote.paymentMethod().method].redirectUrl));
								}
							}
						);

						return true;
					}

				}
				return false;


			}
		}

		return function (placeOrderAction) {
			return placeOrderAction.extend(extendAction);
		};
	});