define([
	'jquery',
	'mage/utils/wrapper'
], function (
	$,
	wrapper
) {
	'use strict';

	return function (placeOrderAction) {

		return wrapper.wrap(placeOrderAction, function (originalAction, messageContainer) {

			function placeOrder(data, event) {
				var self = this;
				if (event) {
					event.preventDefault();
				}
				if (stepNavigator.getActiveItemIndex() == 1) {
					if (this.validate() && additionalValidators.validate()) {
						this.isPlaceOrderActionAllowed(false);

						this.getPlaceOrderDeferredObject()
							.fail(
								function () {
									self.isPlaceOrderActionAllowed(true);
								}
							).done(
							function () {
								self.isPlaceOrderActionAllowed(false);
								fullScreenLoader.stopLoader();
								$(".action.primary.checkout").removeClass('disabled');
								stepNavigator.next();
							}
						);

						return true;
					}
				} else {
					if (this.validate()) {
						this.isPlaceOrderActionAllowed(false);

						this.getPlaceOrderDeferredObject()
							.fail(
								function () {
									self.isPlaceOrderActionAllowed(true);
								}
							).done(
							function () {
								self.afterPlaceOrder();

								if (self.redirectAfterPlaceOrder) {
									redirectOnSuccessAction.execute();
								}
							}
						);

						return true;
					}
				}
				return false;
			}

			return originalAction(serviceUrl, payload, messageContainer);

		})
	}
});