/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

/**
 * @api
 */

define([
	'jquery',
	'ko',
	'mage/utils/wrapper'
], function ($, ko) {
	'use strict';

	// ESTENDO I METODI PER TRIGGERARE UN EVENTO AL CAMBIO

	return function (target) { // target == Result that 'Magento_Checkout/js/model/step-navigator' returns.
		// modify target

		var steps = target.steps;

		var $win = $(window);
		var $body = $("body");

		target.scrollTop = function() {
			$win.scrollTop(0);
		}

		target.navigateTo = function (code, scrollToElementId) {
            var sortedItems = steps().sort(this.sortItems)

			if (!this.isProcessed(code)) {
				return;
			}
			sortedItems.forEach(function (element) {
				if (element.code == code) { //eslint-disable-line eqeqeq
					element.isVisible(true);
					window.location = window.checkoutConfig.checkoutUrl + '#' + code;
					$(window).trigger('step:change', [code]);
				} else {
					element.isVisible(false);
				}
			});
			this.scrollTop();
		}


		target.handleHash = function () {
			var hashString = window.location.hash.replace('#', ''),
				isRequestedStepVisible;

			if (hashString === '') {
				return false;
			}

			if ($.inArray(hashString, this.validCodes) === -1) {
				window.location.href = window.checkoutConfig.pageNotFoundUrl;

				return false;
			}

			isRequestedStepVisible = steps.sort(this.sortItems).some(function (element) {
				return (element.code == hashString || element.alias == hashString) && element.isVisible(); //eslint-disable-line
			});

			//if requested step is visible, then we don't need to load step data from server
			if (isRequestedStepVisible) {
				$(window).trigger('step:change', [hashString]);
				return false;
			}

            steps().sort(this.sortItems).forEach(function (element) {
                if (element.code == hashString || element.alias == hashString) { //eslint-disable-line eqeqeq
					$(window).trigger('step:change', [hashString]);
					element.navigate(element);
				} else {
					element.isVisible(false);
				}

			});

			return false;
		}

		target.setHash = function (hash) {
			window.location.hash = hash;
			this.scrollTop();
			$(window).trigger('step:change', [hash])
		}


		target.addListener = function(){
			$(window).on("step:change", function(event, code){
				$("body").attr("data-step", code);
				if (code=="checkout-login") {
					$("body").addClass("step-login").removeClass("not-step-login");
				}else{
					$("body").removeClass("step-login").addClass("not-step-login");
				}
				if (code=="payment"){
					$('.payment-method._active .primary button.checkout').removeClass("disabled");
				}
			})
		}
		target.addListener();
		return target;
	};

});
