define([
	'mage/utils/wrapper',
	'Magento_Checkout/js/model/quote',
	'Magento_Checkout/js/model/url-builder',
	'Magento_Customer/js/model/customer',
	'Magento_Checkout/js/model/step-navigator',
	'Magento_CheckoutAgreements/js/model/agreements-assigner'
], function (wrapper, quote, urlBuilder, customer,stepNavigator, agreementsAssigner) {
	'use strict';

	return function (placeOrderAction) {
		return wrapper.wrap(placeOrderAction, function (originalAction, paymentData, redirectOnSuccess, messageContainer) {

			var serviceUrl, payload;

			payload = {
				cartId: quote.getQuoteId(),
				billingAddress: quote.billingAddress(),
				paymentMethod: paymentData
			};

			if (customer.isLoggedIn()) {
				console.log("SONO LOGGATO E STO AL PASSO ", stepNavigator.getActiveItemIndex()));
				if(stepNavigator.getActiveItemIndex() == 1) {
					/* from payment step only save payment */
					serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information-custom', {});
				} else{
					/* from review step only place order of save payment */
					serviceUrl = urlBuilder.createUrl('/carts/mine/payment-information', {});
				}
			} else {
				console.log("NON SONO LOGGATO E STO AL PASSO ", stepNavigator.getActiveItemIndex()));
				if(stepNavigator.getActiveItemIndex() == 1) {
					serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information-custom', {
						quoteId: quote.getQuoteId()
					});
				} else{
					serviceUrl = urlBuilder.createUrl('/guest-carts/:quoteId/payment-information', {
						quoteId: quote.getQuoteId()
					});
				}
				payload.email = quote.guestEmail;
			}

			agreementsAssigner(paymentData);
			return;

			return originalAction(serviceUrl, payload, messageContainer);

		});
	};
});