<?php

namespace Drop\FixBundlePromo\Model\Product\Attribute\Backend;

/**
 * Tierprice class
 */
class Tierprice extends \Magento\Catalog\Model\Product\Attribute\Backend\Tierprice
{
    /**
     * @{inheritdoc}
     */
    protected function modifyPriceData($object, $data)
    {
        /** @var \Magento\Catalog\Model\Product $object */
        $data  = $this->forceParentModifyPriceData($object, $data);
        $price = $object->getPrice();

        $specialPrice         = $object->getSpecialPrice();
        $specialPriceFromDate = $object->getSpecialFromDate();
        $specialPriceToDate   = $object->getSpecialToDate();
        $today                = time();

        #22095
        $rht = ($object->getTypeId() === \Magento\Catalog\Model\Product\Type::TYPE_BUNDLE)
        ? $specialPrice && ($object->getPrice() > $specialPrice)
        : $specialPrice && ($object->getPrice() > $object->getFinalPrice());
        #22095

        if ($rht) {
            if ($today >= strtotime($specialPriceFromDate) && $today <= strtotime($specialPriceToDate) ||
                $today >= strtotime($specialPriceFromDate) && $specialPriceToDate === null) {
                $price = $specialPrice;
            }
        }

        foreach ($data as $key => $tierPrice) {
            $percentageValue = $this->getPercentage($tierPrice);
            if ($percentageValue) {
                $data[$key]['price']         = $price * (1 - $percentageValue / 100);
                $data[$key]['website_price'] = $data[$key]['price'];
            }
        }

        return $data;
    }

    /**
     * @{inheritdoc}
     */
    private function forceParentModifyPriceData($object, $data)
    {
        /** @var array $priceItem */
        foreach ($data as $key => $priceItem) {
            if (array_key_exists('price', $priceItem)) {
                $data[$key]['website_price'] = $priceItem['price'];
            }
            if ($priceItem['all_groups']) {
                $data[$key]['cust_group'] = ($this->getGroupManagementInterface())->getAllCustomersGroup()->getId();
            }
        }
        return $data;
    }

    /**
     * @{inheritdoc}
     */
    private function getPercentage($priceRow)
    {
        return isset($priceRow['percentage_value']) && is_numeric($priceRow['percentage_value'])
            ? $priceRow['percentage_value']
            : null;
    }

    /**
     * Get Group Management Interface instance
     *
     * @return \Magento\Customer\Api\GroupManagementInterface
     */
    private function getGroupManagementInterface()
    {
        return \Magento\Framework\App\ObjectManager::getInstance()
            ->get(\Magento\Customer\Api\GroupManagementInterface::class);
    }
}
