<?php
namespace Drop\FatturazioneElettronica\Block\Address\Edit;

use Magento\Framework\View\Element\Template;
use \Drop\FatturazioneElettronica\Block\Checkout\Address\Fields\ShippingLayoutProcessor;

class FatturazioneElettronica extends Template
{
    /**
     * @var string
     */
    protected $_template = 'address/edit/field/fatturazione_elettronica_fields.phtml';

    /**
     * @var \Magento\Customer\Api\Data\AddressInterface
     */
    protected $_address;

    /**
     * @var \Magento\Framework\View\Element\Template\File\Validator
     */
    protected $scopeConfig;

    public function __construct(
        Template\Context $context,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->scopeConfig = $context->getScopeConfig();
    }
    /**
     * @return string
     */
    public function getRequestInvoice()
    {
        /** @var \Magento\Customer\Model\Data\Address $address */
        $address = $this->getAddress();

        $requestInvoice = $address->getCustomAttribute(ShippingLayoutProcessor::REQUEST_INVOICE);
        if (!$requestInvoice) {
            return '';
        }

        if($requestInvoice->getValue() == 1) {
            return "checked='checked'";
        }
        return '';
    }

    public function isMandatoryRequestInvoice() {
        $address = $this->getAddress();
        $countryId = $address->getCountryId();
        $requestInvoiceCountries = $this->getRequestInvoiceCountriesConfiguration();
        if(!empty($countryId) && !empty($requestInvoiceCountries) && in_array($countryId, $requestInvoiceCountries)) {
            return true;
        }
        return false;
    }

    public function getRequestInvoiceCountriesConfiguration() {
        return explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/req_request_invoice_countries'));
    }

    public function isMandatoryBusinessCustomerTypology() {
        $address = $this->getAddress();
        $countryId = $address->getCountryId();
        $businessCustomerTypologyRequired = $this->getCustomerTypologyMandatoryBusinessConfiguration();
        if(!empty($countryId) && !empty($businessCustomerTypologyRequired) && in_array($countryId, $businessCustomerTypologyRequired)) {
            return true;
        }
        return false;
    }

    public function getCustomerTypologyMandatoryBusinessConfiguration() {
        return explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/req_business_customer_typology'));
    }

    /**
     * @return string
     */
    public function getCustomerTypology($customerTipologyRadioValue)
    {
        if($this->isMandatoryBusinessCustomerTypology()) {
            return "checked='checked'";
        }

        /** @var \Magento\Customer\Model\Data\Address $address */
        $address = $this->getAddress();
        $customerTypology = $address->getCustomAttribute(ShippingLayoutProcessor::CUSTOMER_TYPOLOGY);
        if (!$customerTypology) {
            return '';
        }
        if(($customerTypology->getValue() == $customerTipologyRadioValue)) {
            return "checked='checked'";
        }
        return '';
    }

    /**
     * @return string
     */
    public function getFiscalCode()
    {
        /** @var \Magento\Customer\Model\Data\Address $address */
        $address = $this->getAddress();
        $fiscalCode = $address->getCustomAttribute(ShippingLayoutProcessor::FISCAL_CODE);
        if (!$fiscalCode) {
            return '';
        }
        return $fiscalCode->getValue();
    }

    /**
     * @return string
     */
    public function getReceptionDestination()
    {
        /** @var \Magento\Customer\Model\Data\Address $address */
        $address = $this->getAddress();
        $receptionDestination = $address->getCustomAttribute(ShippingLayoutProcessor::RECEPTION_DESTINATION);
        if (!$receptionDestination) {
            return '';
        }
        return $receptionDestination->getValue();
    }

    public function getDebugConfiguration() {
        return $this->scopeConfig->getValue('fatturazione_elettronica/general/debug');
    }

    /**
     * Return the associated address.
     *
     * @return \Magento\Customer\Api\Data\AddressInterface
     */
    public function getAddress()
    {
        return $this->_address;
    }
    /**
     * Set the associated address.
     *
     * @param \Magento\Customer\Api\Data\AddressInterface $address
     */
    public function setAddress(\Magento\Customer\Api\Data\AddressInterface $address)
    {
        $this->_address = $address;
    }

    public function getVatIdValidationIsEnabled() {
        return $this->scopeConfig->getValue('fatturazione_elettronica/general/vatid_ws_validation');
    }
    public function getVatIdValidationAjaxUrl() {
        return $this->getUrl('mfe/validation/vatid', ['_secure' => true]);
    }
    public function getFiscalCodeValidationIsEnabled() {
        return $this->scopeConfig->getValue('fatturazione_elettronica/general/fiscalcode_validation');
    }
    public function getFiscalCodeValidationAjaxUrl() {
        return $this->getUrl('mfe/validation/fiscalcode', ['_secure' => true]);
    }
}
