<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

namespace Drop\FatturazioneElettronica\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\SalesSequence\Model\Builder;
use Magento\SalesSequence\Model\EntityPool;
use Magento\SalesSequence\Model\Config;
use Magento\Framework\Event\ObserverInterface;

/**
 * Class CreateSequence
 */
class SequenceModifierObserver implements ObserverInterface
{
    const SEQUENCE_STORE_ID = 0;
    /**
     * @var \Magento\SalesSequence\Model\ResourceModel\Meta
     */
    private $meta;
    /**
     * @var \Magento\SalesSequence\Model\ResourceModel\Profile
     */
    private $profile;

    /**
     * SequenceModifierObserver constructor.
     * @param \Magento\SalesSequence\Model\ResourceModel\Meta $meta
     * @param \Magento\SalesSequence\Model\ResourceModel\Profile $profile
     */
    public function __construct(
        \Magento\SalesSequence\Model\ResourceModel\Meta $meta,
        \Magento\SalesSequence\Model\ResourceModel\Profile $profile
    )
    {
        $this->meta = $meta;
        $this->profile = $profile;
    }

    /**
     * @param EventObserver $observer
     * @return $this
     */
    public function execute(EventObserver $observer)
    {
        $data = $observer->getData('data');
        $entityTypes = ['fe_invoice_' . $data['id'], 'fe_creditmemo_' . $data['id']];

        foreach ($entityTypes as $entityType) {
            $meta = $this->meta->loadByEntityTypeAndStore($entityType, self::SEQUENCE_STORE_ID);
            $profile = $this->profile->loadActiveProfile($meta->getMetaId());
            $profile->setPrefix($data['custom_numeration']);
            try {
                $profile->save();
            }catch (\Exception $e){
                $this->messageManager->addError(__($e->getMessage()));
            }
        }

        return $this;
    }
}
