<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class ModalitaPagamento implements \Magento\Framework\Option\ArrayInterface
{
    
    const MODALITA_PAGAMENTO_CONTANTI = 'MP01';
    const MODALITA_PAGAMENTO_ASSEGNO = 'MP02';
    const MODALITA_PAGAMENTO_ASSEGNO_CIRCOLARE = 'MP03';
    const MODALITA_PAGAMENTO_CONTANTI_TESORERIA = 'MP04';
    const MODALITA_PAGAMENTO_BONIFICO = 'MP05';
    const MODALITA_PAGAMENTO_VAGLIA = 'MP06';
    const MODALITA_PAGAMENTO_BOLLETINO_BANCARIO = 'MP07';
    const MODALITA_PAGAMENTO_CARTA = 'MP08';
    const MODALITA_PAGAMENTO_RID = 'MP09';
    const MODALITA_PAGAMENTO_RID_UTENZE = 'MP10';
    const MODALITA_PAGAMENTO_RID_VELOCE = 'MP11';
    const MODALITA_PAGAMENTO_RIBA = 'MP12';
    const MODALITA_PAGAMENTO_MAV = 'MP13';
    const MODALITA_PAGAMENTO_QUIETANZA = 'MP14';
    const MODALITA_PAGAMENTO_GIROCONTO = 'MP15';
    const MODALITA_PAGAMENTO_DOMICILIAZIONE_BANCARIA = 'MP16';
    const MODALITA_PAGAMENTO_DOMICILIAZIONE_POSTALE= 'MP17';
    const MODALITA_PAGAMENTO_BOLLETTINO_POSTALE = 'MP18';
    const MODALITA_PAGAMENTO_SEPA = 'MP19';
    const MODALITA_PAGAMENTO_SEPA_CORE = 'MP20';
    const MODALITA_PAGAMENTO_SEPA_B2B = 'MP21';
    const MODALITA_PAGAMENTO_TRATTENUTA = 'MP22';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => '', 'label' => __('-- Please Select --')],
                ['value' => self::MODALITA_PAGAMENTO_CONTANTI, 'label' => __('Contanti')],
                ['value' => self::MODALITA_PAGAMENTO_ASSEGNO, 'label' => __('Assegno')],
                ['value' => self::MODALITA_PAGAMENTO_ASSEGNO_CIRCOLARE, 'label' => __('Assegno circolare')],
                ['value' => self::MODALITA_PAGAMENTO_CONTANTI_TESORERIA, 'label' => __('Contanti presso Tesoreria')],
                ['value' => self::MODALITA_PAGAMENTO_BONIFICO, 'label' => __('Bonifico')],
                ['value' => self::MODALITA_PAGAMENTO_VAGLIA, 'label' => __('Vaglia cambiario')],
                ['value' => self::MODALITA_PAGAMENTO_BOLLETINO_BANCARIO, 'label' => __('Bollettino bancario')],
                ['value' => self::MODALITA_PAGAMENTO_CARTA, 'label' => __('Carta di pagamento')],
                ['value' => self::MODALITA_PAGAMENTO_RID, 'label' => __('RID')],
                ['value' => self::MODALITA_PAGAMENTO_RID_UTENZE, 'label' => __('RID utenze')],
                ['value' => self::MODALITA_PAGAMENTO_RID_VELOCE, 'label' => __('RID veloce')],
                ['value' => self::MODALITA_PAGAMENTO_RIBA, 'label' => __('RIBA')],
                ['value' => self::MODALITA_PAGAMENTO_MAV, 'label' => __('MAV')],
                ['value' => self::MODALITA_PAGAMENTO_QUIETANZA, 'label' => __('Quietanza erario')],
                ['value' => self::MODALITA_PAGAMENTO_GIROCONTO, 'label' => __('Giroconto su conti di contabilità speciale')],
                ['value' => self::MODALITA_PAGAMENTO_DOMICILIAZIONE_BANCARIA, 'label' => __('Domiciliazione bancaria')],
                ['value' => self::MODALITA_PAGAMENTO_DOMICILIAZIONE_POSTALE, 'label' => __('Domiciliazione postale')],
                ['value' => self::MODALITA_PAGAMENTO_BOLLETTINO_POSTALE, 'label' => __('Bollettino di c/c postale')],
                ['value' => self::MODALITA_PAGAMENTO_SEPA, 'label' => __('SEPA Direct Debit')],
                ['value' => self::MODALITA_PAGAMENTO_SEPA_CORE, 'label' => __('SEPA Direct Debit CORE')],
                ['value' => self::MODALITA_PAGAMENTO_SEPA_B2B, 'label' => __('SEPA Direct Debit B2B')],
                ['value' => self::MODALITA_PAGAMENTO_TRATTENUTA, 'label' => __('Trattenuta su somme già riscosse')],
            ];
        }

        return $this->_options;
    }
}
