<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class Destination implements \Magento\Framework\Option\ArrayInterface
{
    
    const DESTINATION_AWS_S3 = 'aws-s3';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => '', 'label' => __('No')],
                ['value' => self::DESTINATION_AWS_S3, 'label' => __('Amazon AWS S3')]
            ];
        }

        return $this->_options;
    }
}
