<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class CondizioniPagamento implements \Magento\Framework\Option\ArrayInterface
{
    
    const CONDIZIONI_PAGAMENTO_RATE = 'TP01';
    const CONDIZIONI_PAGAMENTO_COMPLETO = 'TP02';
    const CONDIZIONI_PAGAMENTO_ANTICIPO = 'TP03';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::CONDIZIONI_PAGAMENTO_RATE, 'label' => __('Pagamento a rate')],
                ['value' => self::CONDIZIONI_PAGAMENTO_COMPLETO, 'label' => __('Pagamento completo')],
                ['value' => self::CONDIZIONI_PAGAMENTO_ANTICIPO, 'label' => __('Anticipo')]
            ];
        }

        return $this->_options;
    }
}
