<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 23/04/2019
 * Time: 10:52
 */

namespace Drop\FatturazioneElettronica\Block\Adminhtml\Edit;


class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
    /**
     * @var \Magento\Store\Model\System\Store
     */
    protected $_systemStore;
    /**
     * @var \Magento\Directory\Model\ResourceModel\Country\CollectionFactory
     */
    protected $_countryFactory;


    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Directory\Model\ResourceModel\Country\CollectionFactory $countryFactory,
        array $data = []
    )
    {
        $this->_countryFactory = $countryFactory;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Prepare form.
     *
     * @return $this
     */
    protected function _prepareForm()
    {
        $dateFormat = $this->_localeDate->getDateFormat(\IntlDateFormatter::SHORT);
        $model = $this->_coreRegistry->registry('taxvat_data');
        $form = $this->_formFactory->create(
            [
                'data' => [
                    'id'      => 'edit_form',
                    'enctype' => 'multipart/form-data',
                    'action'  => $this->getData('action'),
                    'method'  => 'post'
                ]
            ]
        );

        $form->setHtmlIdPrefix('wkgrid_');
        if ($model->getId()) {
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Edit Custom Taxvat/Numeration'), 'class' => 'fieldset-wide']
            );
            $fieldset->addField('id', 'hidden', ['name' => 'id']);
        } else {
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Add Custom Taxvat/Numeration'), 'class' => 'fieldset-wide']
            );
        }

        $fieldset->addField(
            'countries',
            'multiselect',
            [
                'name'     => 'countries',
                'label'    => __('Countries'),
                'id'       => 'countries',
                'title'    => __('Countries'),
                'values'   => $this->_countryFactory->create()->toOptionArray(),
                'class'    => 'required-entry',
                'required' => true,
            ]
        );

        $fieldset->addField(
            'custom_taxvat',
            'text',
            [
                'name'     => 'custom_taxvat',
                'label'    => __('Custom Taxvat'),
                'id'       => 'custom_taxvat',
                'title'    => __('Custom Taxvat'),
                'class'    => 'required-entry',
                'required' => true,
            ]
        );

        $fieldset->addField(
            'custom_numeration',
            'text',
            [
                'name'     => 'custom_numeration',
                'label'    => __('Custom Numeration'),
                'id'       => 'custom_numeration',
                'title'    => __('Custom Numeration'),
                'class'    => 'required-entry',
                'required' => true,
            ]
        );


        $fieldInitNumbData = [
            'name'     => 'initial_number',
            'label'    => __('Initial Number'),
            'id'       => 'initial_number',
            'title'    => __('Initial Number'),
            'class'    => 'required-entry',
            'value'    => '1',
            'required' => true,
        ];
        if ($model->getId()) {
            $fieldInitNumbData['readonly'] = true;
        }

        $fieldset->addField(
            'initial_number',
            'text',
            $fieldInitNumbData
        );


        if ($model->getId()) {
            $form->setValues($model->getData());
        }
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
}