<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class FormatoTrasmissione implements \Magento\Framework\Option\ArrayInterface
{
    
    const FORMATO_TRASMISSIONE_PA = 'FPA12';
    const FORMATO_TRASMISSIONE_PRIVATI = 'FPR12';
    
    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::FORMATO_TRASMISSIONE_PA, 'label' => __('Fattura verso PA')],
                ['value' => self::FORMATO_TRASMISSIONE_PRIVATI, 'label' => __('Fattura verso Privati')],
            ];
        }

        return $this->_options;
    }
}
