<?php

namespace Drop\FatturazioneElettronica\Model\Config\Source;

use \Magento\ImportExport\Model\Import\ErrorProcessing\ProcessingErrorAggregatorInterface;

class EsigibilitaIva implements \Magento\Framework\Option\ArrayInterface
{
    
    const ESIGIBILITA_IVA_IMMEDIATA = 'I';
    const ESIGIBILITA_IVA_DIFFERITA = 'D';
    const ESIGIBILITA_IVA_SCISSIONE = 'S';

    /**
     * Options array
     *
     * @var array
     */
    protected $_options;

    /**
     * Return options array
     *
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            $this->_options = [
                ['value' => self::ESIGIBILITA_IVA_IMMEDIATA, 'label' => __('IVA ad esigibilità immediata')],
                ['value' => self::ESIGIBILITA_IVA_DIFFERITA, 'label' => __('IVA ad esigibilità differita')],
                ['value' => self::ESIGIBILITA_IVA_SCISSIONE, 'label' => __('Scissione dei pagamenti')]
            ];
        }

        return $this->_options;
    }
}
