define([
    'jquery',
    'mage/translate'
], function ($, $t) {
    'use strict';

    return function (Component) {
        return Component.extend({
            defaults: {
                template: 'Drop_FatturazioneElettronica/billing-address'
            },
            feAttributes: ['request_invoice', 'customer_typology', 'fiscal_code', 'fe_reception_destination'],

            /**
             * Check if is Fatturazione Elettronica attribute
             * @param attribute
             * @returns {boolean}
             */
            getIsFeField: function(attribute) {
                if(this.feAttributes.includes(attribute)) {
                    return true;
                }
                return false;
            }

        });
    }
});
