<?php
/**
 * Created by PhpStorm.
 * User: Alberto Pallotto
 * Date: 24/04/2019
 * Time: 10:16
 */

namespace Drop\FatturazioneElettronica\Controller\Adminhtml\TaxvatNumeration;


class massDelete extends \Magento\Backend\App\Action
{
    /**
     * @var \Magento\Framework\View\Result\PageFactory
     */
    var $resulPageFactory;
    /**
     * @var \Webkul\Grid\Model\GridFactory
     */
    var $taxvatFactory;
    /**
     * @var \Magento\Framework\Event\Manager
     */
    var $eventManager;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Webkul\Grid\Model\GridFactory $gridFactory
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Drop\FatturazioneElettronica\Model\TaxvatNumerationFactory $taxvatFactory,
        \Magento\Framework\Event\Manager $eventManager
    )
    {
        $this->resulPageFactory = $resultPageFactory;
        $this->taxvatFactory = $taxvatFactory;
        $this->eventManager = $eventManager;
        parent::__construct($context);
    }

    /**
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     * @SuppressWarnings(PHPMD.NPathComplexity)
     */
    public function execute()
    {
        $params = $this->getRequest()->getParams();

        if (isset($params['excluded']) && $params['excluded'] === 'false') {
            $model = $this->taxvatFactory->create();
            $collection = $model->getCollection();
            foreach ($collection as $item) {
                $model->load($item->getId());
                try {
                    $model->delete();
                } catch (\Exception $e) {
                    $this->messageManager->addError($e->getMessage());
                    $this->_redirect('efatt/taxvatnumeration/');
                }
            }

            $successMessage = __('All record(s) have been deleted.');
        } else {
            foreach ($params['selected'] as $deleteId) {
                $model = $this->taxvatFactory->create();
                $model->load($deleteId);
                try {
                    $model->delete();
                } catch (\Exception $e) {
                    $this->messageManager->addError($e->getMessage());
                    $this->_redirect('efatt/taxvatnumeration/');
                }
            }
            $successMessage = __('A total of %1 record(s) have been deleted.', count($params['selected']));
        }

        $this->messageManager->addSuccess($successMessage);
        $this->_redirect('efatt/taxvatnumeration/');
    }
}