<?php

namespace Drop\FatturazioneElettronica\Plugin\Checkout;

use Magento\Checkout\Block\Checkout\LayoutProcessor;
use Drop\FatturazioneElettronica\Block\Checkout\Address\Fields\ShippingLayoutProcessor;

class BillingLayoutProcessor
{
    /**
     * @param LayoutProcessor $subject
     * @param array $result
     * @return array|mixed
     */
    public function afterProcess(
        LayoutProcessor $subject,
        array $result
    ) {
        $paymentForms = $result['components']['checkout']['children']['steps']['children']
        ['billing-step']['children']['payment']['children']
        ['payments-list']['children'];

        $paymentMethodForms = array_keys($paymentForms);

        if (!isset($paymentMethodForms)) {
            return $result;
        }

        foreach ($paymentMethodForms as $paymentMethodForm) {
            $paymentMethodCode = str_replace('-form', '', $paymentMethodForm, $paymentMethodCode);

            $result = $this->removeField($result,ShippingLayoutProcessor::REQUEST_INVOICE, $paymentMethodForm, $paymentMethodCode);
            $result = $this->removeField($result, ShippingLayoutProcessor::CUSTOMER_TYPOLOGY, $paymentMethodForm, $paymentMethodCode);
            $result = $this->removeField($result, ShippingLayoutProcessor::FISCAL_CODE, $paymentMethodForm, $paymentMethodCode);
            $result = $this->removeField($result, ShippingLayoutProcessor::RECEPTION_DESTINATION, $paymentMethodForm, $paymentMethodCode);
            $result = $this->removeField($result, 'vat_id', $paymentMethodForm, $paymentMethodCode);
            $result = $this->removeField($result, 'company', $paymentMethodForm, $paymentMethodCode);
        }

        return $result;
    }

    public function removeField($result, $fieldName, $paymentMethodForm, $paymentMethodCode)
    {
        $result
        ['components']
        ['checkout']
        ['children']
        ['steps']
        ['children']
        ['billing-step']
        ['children']
        ['payment']
        ['children']
        ['payments-list']
        ['children']
        [$paymentMethodForm]
        ['children']
        ['form-fields']
        ['children']
        [$fieldName] = [
            'validation' => [],
            'visible' => true,
        ];

        return $result;
    }

}
