<?php

namespace Drop\FatturazioneElettronica\Observer\Order;

class CreditMemoSave implements \Magento\Framework\Event\ObserverInterface
{

    const FE_CREDITMEMO_ENTITY_TYPE = 'fe_creditmemo';
    const FE_CREDITMEMO_STORE_ID = 0;

    const FE_CREDITMEMO_CREDITMEMO_TYPE = 'Nota di Credito';
    const FE_CREDITMEMO_STORNO_TYPE = 'Storno';

    const XML_EU_COUNTRIES_PATH = 'general/country/eu_countries';
    const DIGITS_CONFIG_PATH = 'fatturazione_elettronica/general/digits';
    const PREFIX_CONFIG_PATH = 'fatturazione_elettronica/general/prefix';

    /**
     * @var \Magento\SalesSequence\Model\Manager
     */
    protected $sequenceManager;
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var \Psr\Log\LoggerInterface
     */
    protected $logger;
    /**
     * @var \Drop\FatturazioneElettronica\Model\TaxvatNumerationFactory
     */
    private $taxvatFactory;
    /**
     * @var \Magento\SalesSequence\Model\ResourceModel\Meta
     */
    private $meta;
    /**
     * @var \Magento\SalesSequence\Model\ResourceModel\Profile
     */
    private $profile;

    /**
     * InvoicePay constructor.
     * @param \Magento\SalesSequence\Model\Manager $sequenceManager
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        \Magento\SalesSequence\Model\Manager $sequenceManager,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Drop\FatturazioneElettronica\Model\TaxvatNumerationFactory $taxvatFactory,
        \Magento\SalesSequence\Model\ResourceModel\Meta $meta,
        \Magento\SalesSequence\Model\ResourceModel\Profile $profile,
        \Psr\Log\LoggerInterface $logger
    ) {
        $this->sequenceManager = $sequenceManager;
        $this->scopeConfig = $scopeConfig;
        $this->logger = $logger;
        $this->taxvatFactory = $taxvatFactory;
        $this->meta = $meta;
        $this->profile = $profile;
    }

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $creditmemo = $observer->getEvent()->getCreditmemo();
        if(!$creditmemo) {
            $this->logger->debug(__METHOD__ . ' - Creditmemo not found.');
            return false;
        }

        $order = $creditmemo->getOrder();
        if(!$order) {
            $this->logger->debug(__METHOD__ . ' - Order not found.');
            return false;
        }

        $billingAddress = $order->getShippingAddress();
        if(!$billingAddress) {
            $this->logger->debug(__METHOD__ . ' - Order Billing Address not found.');
            return false;
        }

        $euCountries = explode(',', $this->scopeConfig->getValue(self::XML_EU_COUNTRIES_PATH));

        $creditmemo->setDocumentType(self::FE_CREDITMEMO_STORNO_TYPE);
        if($billingAddress->getRequestInvoice()) {
            try {
                $docType = in_array($billingAddress->getCountryId(), $euCountries) ? self::FE_CREDITMEMO_STORNO_TYPE : self::FE_CREDITMEMO_CREDITMEMO_TYPE;

                $customTaxvatNumeration = $this->taxvatFactory->create()
                    ->getCollection()
                    ->addFieldToFilter('countries', ['like' => '%' . $billingAddress->getCountryId() . '%'])
                    ->getFirstItem();
                $creditmemoEntityType = self::FE_CREDITMEMO_ENTITY_TYPE.'_'.$customTaxvatNumeration->getId();

                $nextValue = $this->sequenceManager->getSequence($creditmemoEntityType, self::FE_CREDITMEMO_STORE_ID)->getNextValue();
                $nextValue = $this->setNextValueLenght($creditmemoEntityType, $nextValue);
                $creditmemo->setFeIncrementId($nextValue)
                    ->setDocumentType($docType)
                    ->addComment('Custom fe_increment_id: #' . $nextValue);
            } catch (\Exception $e) {
                $this->revertLastGeneratedSequenceNumber($nextValue);
                $this->logger->error("Failed to set Custom fe_increment_id to creditmemo {$creditmemo->getIncrementId()}: " . $e->getMessage());
            }

            try {
                $order->addStatusHistoryComment('Custom creditmemo fe_increment_id: #' . $nextValue)->save();
            } catch (\Exception $e) {
                $this->logger->error("Failed to set History comment to order {$order->getIncrementId()}: " . $e->getMessage());
            }
        }

        return $this;
    }

    /**
     * @param $lastGeneratedNumber
     */
    private function revertLastGeneratedSequenceNumber($lastGeneratedNumber) {
        //Aggiungere metodo resetLastValue a \Magento\SalesSequence\Model\Sequence che fa queste query:
        //DELETE FROM sequence_fe_creditmemo_0 WHERE sequence_value = $lastGeneratedNumber;
        //ALTER TABLE sequence_fe_creditmemo_0 AUTO_INCREMENT = $lastGeneratedNumber;
        $this->logger->error(__METHOD__ . ' TODO');
        return $this;
    }

    /**
     * @param $nextValue
     * @return string
     */
    private function setNextValueLenght($creditmemoEntityType, $nextValue) {
        $digitsConfigValue = $this->scopeConfig->getValue(self::DIGITS_CONFIG_PATH);

        $meta = $this->meta->loadByEntityTypeAndStore($creditmemoEntityType, self::FE_CREDITMEMO_STORE_ID);
        $profile = $this->profile->loadActiveProfile($meta->getMetaId());
        $prefixConfigValue = $profile->getPrefix();

        $nextValue = str_replace($prefixConfigValue, '', $nextValue);
        if($digitsConfigValue > strlen($nextValue)) {
            $zeroAddString = '';
            for($i=0; $i<($digitsConfigValue - strlen($nextValue)); $i++) {
                $zeroAddString .= '0';
            }
            $nextValue = $zeroAddString . $nextValue;
        } elseif($digitsConfigValue < strlen($nextValue)) {
            $nextValue = substr($nextValue, (strlen($nextValue) - $digitsConfigValue));
        }
        return ($prefixConfigValue . $nextValue);
    }

}
