<?php
/**
 * AttributeChecker
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\FatturazioneElettronica\Model;

use Magento\Customer\Api\AddressMetadataInterface;
use Magento\Customer\Api\AddressMetadataManagementInterface;
use Magento\Customer\Model\Metadata\AttributeResolver;

class AttributeChecker extends \Magento\Customer\Model\AttributeChecker
{

    /**
     * @var AddressMetadataInterface
     */
    private $addressMetadata;

    /**
     * @var AttributeResolver
     */
    private $attributeResolver;

    /**
     * @param AddressMetadataInterface $addressMetadata
     * @param AttributeResolver $attributeResolver
     */
    public function __construct(
        AddressMetadataInterface $addressMetadata,
        AttributeResolver $attributeResolver
    ) {
        $this->addressMetadata = $addressMetadata;
        $this->attributeResolver = $attributeResolver;
        parent::__construct($addressMetadata,$attributeResolver);
    }


    public function isAttributeRequired($attributeCode) {
        $isRequired = false;
        $attributeMetadata = $this->addressMetadata->getAttributeMetadata($attributeCode);
        if ($attributeMetadata) {
            /** @var Attribute $attribute */
            $attribute = $this->attributeResolver->getModelByAttribute(
                AddressMetadataManagementInterface::ENTITY_TYPE_ADDRESS,
                $attributeMetadata
            );
            $isRequired = $attribute->getIsRequired();
        }

        return $isRequired;
    }
}
