<?php
/**
 * ConfigProvider
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace Drop\FatturazioneElettronica\Model;

use Magento\Checkout\Model\ConfigProviderInterface;

class ConfigProvider implements ConfigProviderInterface
{
    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    private $scopeConfig;
    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlBuilder;

    /**
     * ConfigProvider constructor.
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\UrlInterface $urlBuilder
    ) {
        $this->scopeConfig = $scopeConfig;
        $this->urlBuilder = $urlBuilder;
    }

    public function getConfig()
    {
        $config = [];
        $config['fatturazione_elettronica']['debug'] = $this->scopeConfig->getValue('fatturazione_elettronica/general/debug');
        $config['fatturazione_elettronica']['req_request_invoice_countries'] = explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/req_request_invoice_countries'));
        $config['fatturazione_elettronica']['req_business_customer_typology'] = explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/req_business_customer_typology'));
        $config['fatturazione_elettronica']['vatid_ws_validation'] = explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/vatid_ws_validation'));
        $config['fatturazione_elettronica']['fiscalcode_validation'] = explode(',', $this->scopeConfig->getValue('fatturazione_elettronica/general/fiscalcode_validation'));
        $config['fatturazione_elettronica']['vat_id_validation_url'] = $this->urlBuilder->getUrl('mfe/validation/vatid', ['_secure' => true]);
        $config['fatturazione_elettronica']['fiscal_code_validation_url'] = $this->urlBuilder->getUrl('mfe/validation/fiscalcode', ['_secure' => true]);
        return $config;
    }
}
