/**
 * @todo: Extend istead of overwrite
 */
define([
    'uiComponent',
    'Magento_Customer/js/customer-data'
], function (Component, customerData) {
    'use strict';

    var countryData = customerData.get('directory-data');

    return Component.extend({
        defaults: {
            template: 'Drop_FatturazioneElettronica/shipping-information/address-renderer/default'
        },
        feAttributes: ['request_invoice', 'customer_typology', 'fiscal_code', 'fe_reception_destination'],

        /**
         * @param {*} countryId
         * @return {String}
         */
        getCountryName: function (countryId) {
            return countryData()[countryId] != undefined ? countryData()[countryId].name : ''; //eslint-disable-line
        },

        /**
         * Check if is Fatturazione Elettronica attribute
         * @param attribute
         * @returns {boolean}
         */
        getIsFeField: function(attribute) {
            if(this.feAttributes.includes(attribute)) {
                return true;
            }
            return false;
        }

    });
});
